define("servicedesk/internal/agent/settings/automation/internal-automation-service", [
    "jquery",
    "servicedesk/internal/agent/settings/automation/util/async-utils/async-utils",
    "exports"
], function (
    $,
    AsyncUtils,
    exports
) {

    var preconditions = [];

    /**
     * Registers an action (function) to be run when an automation rule is about to be created.
     *
     * @param {Function} func A function that returns a deferred.
     */
    exports.registerPrecondition = function (func) {
        preconditions.push(func);
    };

    /**
     * Runs all the preconditions. The first one must resolve before the next one will be run.
     */
    exports.resolvePreconditions = function () {
        return AsyncUtils.execDeferredFunctionQueue(preconditions, arguments);
    };
});