define("servicedesk/internal/agent/settings/automation/blueprint/select-blueprint-dialog", [
    "automation/underscore",
    "jquery",
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/util/analytics/analytics",
    "servicedesk/internal/agent/settings/automation/util/navigator/navigator",
    "exports"
], function (
    _,
    $,
    Brace,
    tracker,
    Navigator,
    exports
) {
    var SelectBluePrintView = Brace.View.extend({

        template: ServiceDesk.Templates.Agent.Settings.BluePrints.newBluePrint,

        events: {
            "click .js-blue-print" : "handleBluePrintClick",
            "focus .js-blue-print-radio": "handleRadioFocus",
            "change .js-blue-print-radio": "handleRadioChange"
        },
        handleFormSubmit: function () {
            var bluePrintModuleKey = this.$(":radio:checked").val();

            tracker.trackEvent("automation.selectblueprint.blueprint.select", {
                bluePrintModuleKey: bluePrintModuleKey
            });

            Navigator.navigateToFragment("blueprint/" + encodeURIComponent(bluePrintModuleKey));
        },
        handleBluePrintClick: function(e) {
            // unselect
            var $radios = this.$(":radio");
            $radios.removeAttr("checked");

            // select
            var $container = $(e.currentTarget);
            var $radio = $container.find('input');
            $radio.attr("checked", "checked");

            // fire change event
            $radios.change();
        },
        /**
         * Our radio button is hidden off the screen, so we rebound the display of selection to the parent label which
         * is visible on screen.
         */
        handleRadioChange: function (e) {
            var $radio = $(e.currentTarget);
            var $container = $(e.currentTarget).closest(".sd-blue-print");
            $container.toggleClass("sd-selected", $radio.is(":checked"))
        },
        /**
         * Focuses first input
         */
        focus: function () {
            this.$el.find(".sd-blue-print:first").focus()
        },
        /**
         * Our radio button is hidden off the screen, so we rebound the focus to the parent label which is visible on screen.
         */
        handleRadioFocus: function (e) {
            $(e.currentTarget).closest(".sd-blue-print").focus();
        },
        render: function () {
            this.$el.html(this.template(this.model.toJSON()));
            return this;
        }
    });
    exports.create = function (options) {

        var selectBluePrintView = new SelectBluePrintView(options);

        var dialog = new JIRA.FormDialog({
            id: "sd-blueprint-dialog",
            width: 600,
            content: function (ready) {
                ready(selectBluePrintView.render().$el);
            },
            onContentRefresh: function () {
                selectBluePrintView.focus();
            },
            submitHandler: function (e) {
                selectBluePrintView.handleFormSubmit();

                dialog.hide();
                e.preventDefault();
            }
        });

        $(dialog).one("Dialog.hide", function(e, el, reason) {
            if (reason == JIRA.Dialog.HIDE_REASON.cancel || reason == JIRA.Dialog.HIDE_REASON.escape) {
                tracker.trackEvent("automation.selectblueprint.cancel");
            }
        });

        dialog.show();

        return selectBluePrintView;
    };
});