/*
 * Decompiled with CFR 0.152.
 */
package it.com.atlassian.servicedesk.plugins.automation;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSetService;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.ServiceFlags;
import io.atlassian.fugue.Option;
import it.com.atlassian.servicedesk.plugins.automation.RuleSetBackdoor;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class RuleSetBackdoorImpl
implements RuleSetBackdoor {
    private final ProjectService projectService;
    private final RuleSetService ruleSetService;
    private final UserUtil userUtil;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public RuleSetBackdoorImpl(@Nonnull ProjectService projectService, @Nonnull RuleSetService ruleSetService, @Nonnull UserUtil userUtil, @Nonnull JiraAuthenticationContext jiraAuthenticationContext) {
        this.projectService = projectService;
        this.ruleSetService = ruleSetService;
        this.userUtil = userUtil;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public void deleteAllRuleSetByProject(String projectKey, String userKey) {
        ApplicationUser user = this.userUtil.getUserByName(userKey);
        Option userOption = Option.option((Object)user);
        Project project = null;
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(user, projectKey);
        if (projectResult.isValid()) {
            project = projectResult.getProject();
            io.atlassian.fugue.Either ruleSetsByProjectEither = StepsConverters.newerEither((Either)this.ruleSetService.getActiveRuleSetsByProject(StepsConverters.olderOption((Option)userOption), project, ServiceFlags.NONE));
            if (ruleSetsByProjectEither.isRight()) {
                for (RuleSet ruleSet : (List)ruleSetsByProjectEither.right().get()) {
                    this.ruleSetService.delete(StepsConverters.olderOption((Option)userOption), ruleSet, ServiceFlags.NONE);
                }
            }
        }
    }

    @Override
    public Option<List<RuleSet>> getAllRuleSetByProject(String projectKey) {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        return (Option)Option.option((Object)this.projectService.getProjectByKey(projectKey)).fold(() -> Option.none(), projectResult -> this.getActiveRuleSetByProjectKey(loggedInUser, (ProjectService.GetProjectResult)projectResult));
    }

    private Option getActiveRuleSetByProjectKey(ApplicationUser loggedInUser, ProjectService.GetProjectResult projectResult) {
        return (Option)this.ruleSetService.getActiveRuleSetsByProject(loggedInUser, projectResult.getProject()).fold(error -> Option.none(), ruleSets -> Option.some((Object)ruleSets));
    }
}

