/*
 * Decompiled with CFR 0.152.
 */
package it.com.atlassian.servicedesk.plugins.automation;

import com.atlassian.fugue.Option;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.engine.RulesEngine;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.UserMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.rule.RuleReference;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerContext;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerService;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import it.com.atlassian.servicedesk.plugins.automation.AutomationBackdoor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class AutomationBackdoorImpl
implements AutomationBackdoor {
    private final RulesEngine rulesEngine;
    private final WhenHandlerService whenHandlerService;
    private final RuleMessageBuilderService ruleMessageBuilderService;
    private final RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService;
    private final UserMessageHelper userMessageHelper;
    private final UserManager userManager;
    private Map<String, List<RuleMessage>> actionResults = new HashMap<String, List<RuleMessage>>();

    @Autowired
    public AutomationBackdoorImpl(@Nonnull RulesEngine rulesEngine, @Nonnull WhenHandlerService whenHandlerService, @Nonnull RuleMessageBuilderService ruleMessageBuilderService, @Nonnull RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService, @Nonnull UserMessageHelper userMessageHelper, @Nonnull UserManager userManager) {
        this.rulesEngine = rulesEngine;
        this.whenHandlerService = whenHandlerService;
        this.ruleMessageBuilderService = ruleMessageBuilderService;
        this.ruleExecutionCommandBuilderService = ruleExecutionCommandBuilderService;
        this.userMessageHelper = userMessageHelper;
        this.userManager = userManager;
    }

    @Override
    public void triggerWhen(String moduleKey, String whenId, Map<String, String> messageContents) {
        this.triggerWhen(moduleKey, whenId, messageContents, null);
    }

    @Override
    public void triggerWhen(String moduleKey, String whenId, Map<String, String> messageContents, String userKey) {
        ApplicationUser user;
        List contextEithers = this.whenHandlerService.getContextsForWhenHandlerKey(moduleKey).stream().map(StepsConverters::newerEither).collect(Collectors.toList());
        RuleMessage message = this.ruleMessageBuilderService.builder().putAllValues(messageContents).build();
        if (!StringUtils.isBlank((String)userKey) && (user = this.userManager.getUserByKey(userKey)) != null) {
            this.userMessageHelper.setUser(message, "currentUser", user);
        }
        RuleExecutionCommandBuilder builder = this.ruleExecutionCommandBuilderService.builder().ruleMessage(message);
        ArrayList commands = Lists.newArrayList();
        for (Either context : contextEithers) {
            io.atlassian.fugue.Option whenIdOpt;
            if (!context.isRight() || !(whenIdOpt = StepsConverters.newerOption((Option)((WhenHandlerContext)context.right().get()).getWhenHandlerConfiguration().getData().getValue("when-id"))).isDefined() || !((String)whenIdOpt.get()).equals(whenId)) continue;
            RuleReference ruleReference = ((WhenHandlerContext)context.right().get()).getRuleReference();
            commands.add(builder.ruleReference(ruleReference).build());
            break;
        }
        this.rulesEngine.enqueue((List)commands);
    }

    @Override
    public void resetRuleResults() {
        this.actionResults.clear();
    }

    @Override
    public io.atlassian.fugue.Option<List<RuleMessage>> getRuleResults(String actionId) {
        return io.atlassian.fugue.Option.option(this.actionResults.get(actionId));
    }

    @Override
    public void addRuleResult(String actionId, RuleMessage ruleMessage) {
        ArrayList messages = this.actionResults.get(actionId);
        if (null != messages) {
            messages.add((RuleMessage)ruleMessage);
            this.actionResults.put(actionId, messages);
        } else {
            messages = Lists.newArrayList((Object[])new RuleMessage[]{ruleMessage});
            this.actionResults.put(actionId, messages);
        }
    }

    @Override
    public boolean getActionTriggered(String actionId) {
        io.atlassian.fugue.Option<List<RuleMessage>> ruleResultsOpt = this.getRuleResults(actionId);
        if (ruleResultsOpt.isEmpty()) {
            return false;
        }
        return !((List)ruleResultsOpt.get()).isEmpty();
    }
}

