/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.When;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.WhenHandlerConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.WhenValidationResult;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.ComponentConfigurationInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.WhenInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.ValidationResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.WhenHandlerResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.ValidationResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.WhenResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.WhenSummaryResponse;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WhenResponseBuilder {
    private final WhenHandlerResponseBuilder whenHandlerResponseBuilder;
    private final ValidationResponseBuilder validationResponseBuilder;

    @Autowired
    public WhenResponseBuilder(@Nonnull WhenHandlerResponseBuilder whenHandlerResponseBuilder, @Nonnull ValidationResponseBuilder validationResponseBuilder) {
        Assertions.notNull((String)"whenHandlerResponseBuilder", (Object)whenHandlerResponseBuilder);
        Assertions.notNull((String)"validationResponseBuilder", (Object)validationResponseBuilder);
        this.validationResponseBuilder = validationResponseBuilder;
        this.whenHandlerResponseBuilder = whenHandlerResponseBuilder;
    }

    public WhenResponse build(@Nonnull ApplicationUser user, @Nonnull When when, @Nonnull WhenValidationResult whenValidationResult) {
        List whenHandlerConfigurations = when.getWhenHandlerConfigurations();
        ValidationResponse validationResponse = this.validationResponseBuilder.build(user, whenValidationResult.getWhenValidationResult());
        ArrayList whenHandlerResponses = Lists.newArrayList();
        for (int i = 0; i < whenHandlerConfigurations.size(); ++i) {
            WhenHandlerConfiguration whenHandlerConfiguration = (WhenHandlerConfiguration)whenHandlerConfigurations.get(i);
            ValidationResult validationResult = (ValidationResult)whenValidationResult.getWhenHandlerResults().get(i);
            whenHandlerResponses.add(this.whenHandlerResponseBuilder.buildWhenHandler(user, whenHandlerConfiguration, validationResult));
        }
        return new WhenResponse(whenHandlerResponses, validationResponse);
    }

    public WhenSummaryResponse buildSummary(@Nonnull ApplicationUser user, @Nonnull When when) {
        List whenHandlerConfigurations = when.getWhenHandlerConfigurations();
        ArrayList whenHandlerSummaryResponses = Lists.newArrayList();
        for (WhenHandlerConfiguration whenHandlerConfiguration : whenHandlerConfigurations) {
            whenHandlerSummaryResponses.add(this.whenHandlerResponseBuilder.buildWhenHandlerSummaryResponse(user, whenHandlerConfiguration));
        }
        return new WhenSummaryResponse(whenHandlerSummaryResponses);
    }

    public WhenResponse buildFromInput(ApplicationUser user, WhenInputImpl whenInput, WhenValidationResult whenValidationResult) {
        List<ComponentConfigurationInputImpl> whenHandlerConfigurations = whenInput.getWhenHandlerConfigurations();
        ValidationResponse validationResponse = this.validationResponseBuilder.build(user, whenValidationResult.getWhenValidationResult());
        ArrayList whenHandlerResponses = Lists.newArrayList();
        for (int i = 0; i < whenHandlerConfigurations.size(); ++i) {
            ComponentConfigurationInputImpl whenHandlerConfiguration = whenHandlerConfigurations.get(i);
            ValidationResult validationResult = (ValidationResult)whenValidationResult.getWhenHandlerResults().get(i);
            whenHandlerResponses.add(this.whenHandlerResponseBuilder.buildWhenHandlerInput(user, whenHandlerConfiguration, validationResult));
        }
        return new WhenResponse(whenHandlerResponses, validationResponse);
    }
}

