/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsSpecificUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.project.ProjectRunAsUserContextConfigManager;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.ProjectRunAsUserSettingsResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.RunAsUserContextConfigResponse;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RunAsUserContextConfigResponseBuilder {
    private final UserManager userManager;
    private final ProjectRunAsUserContextConfigManager projectRunAsUserContextConfigManager;

    @Autowired
    public RunAsUserContextConfigResponseBuilder(@Nonnull UserManager userManager, ProjectRunAsUserContextConfigManager projectRunAsUserContextConfigManager) {
        this.projectRunAsUserContextConfigManager = projectRunAsUserContextConfigManager;
        this.userManager = userManager;
    }

    public ProjectRunAsUserSettingsResponse buildProjectSettingsResponse(Project project, Option<RunAsUserContextConfig> runAsUserContextConfigOpt, boolean isUpdated) {
        Option<RunAsUserContextConfigResponse> configResponseOption = this.build(runAsUserContextConfigOpt);
        RunAsUserContextConfigResponse configResponse = (RunAsUserContextConfigResponse)configResponseOption.getOrNull();
        if (runAsUserContextConfigOpt.isDefined() && configResponse != null) {
            if (!configResponse.getType().equals("specificUser")) {
                configResponse = null;
            } else {
                Either<AnError, Unit> anErrorUnitEither = this.projectRunAsUserContextConfigManager.validateContextConfigForProject(project, (RunAsUserContextConfig)runAsUserContextConfigOpt.get());
                if (anErrorUnitEither.isLeft()) {
                    configResponse = RunAsUserContextConfigResponse.builder().type(configResponse.getType()).user(configResponse.getUser().getUserKey(), (Option<String>)Option.option((Object)configResponse.getUser().getUserDisplayName()), false).build();
                }
            }
        }
        boolean isSet = configResponse != null;
        return new ProjectRunAsUserSettingsResponse(isSet, isUpdated, configResponse);
    }

    public Option<RunAsUserContextConfigResponse> build(Option<RunAsUserContextConfig> runAsUserContextConfigOpt) {
        if (runAsUserContextConfigOpt.isEmpty()) {
            return Option.none();
        }
        RunAsUserContextConfig runAsUserContextConfig = (RunAsUserContextConfig)runAsUserContextConfigOpt.get();
        RunAsUserContextConfigResponse.Builder responseBuilder = RunAsUserContextConfigResponse.builder();
        if (runAsUserContextConfig.getType().equals("currentUser")) {
            responseBuilder.type("currentUser");
        } else {
            responseBuilder.type("specificUser");
            RunAsSpecificUserContextConfig specificUserConfig = (RunAsSpecificUserContextConfig)runAsUserContextConfig;
            String configuredUserKey = specificUserConfig.getUserKey();
            ApplicationUser specificUser = this.userManager.getUserByKey(configuredUserKey);
            if (specificUser == null) {
                responseBuilder.user(configuredUserKey, (Option<String>)Option.none(), false);
            } else {
                responseBuilder.user(specificUser.getKey(), (Option<String>)Option.some((Object)specificUser.getDisplayName()), true);
            }
        }
        return Option.some((Object)responseBuilder.build());
    }
}

