/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.project.ProjectContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.project.RuleSetProjectContextConfigService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.project.input.ProjectContextInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.RuleSetInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.ProjectContextResponse;
import com.atlassian.util.concurrent.Assertions;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectContextResponseBuilder {
    private final RuleSetProjectContextConfigService projectContextService;

    @Autowired
    public ProjectContextResponseBuilder(@Nonnull RuleSetProjectContextConfigService projectContextService) {
        Assertions.notNull((String)"projectContextService", (Object)projectContextService);
        this.projectContextService = projectContextService;
    }

    public ProjectContextResponse build(@Nonnull ApplicationUser user, @Nonnull RuleSet ruleSet) {
        io.atlassian.fugue.Either contextForRuleSetEither = StepsConverters.newerEither((Either)this.projectContextService.getProjectContextConfigForRuleSet(ruleSet));
        if (contextForRuleSetEither.isLeft() || ((ProjectContextConfig)contextForRuleSetEither.right().get()).getProjectIds().isEmpty()) {
            return new ProjectContextResponse(null);
        }
        Long projectId = (Long)((ProjectContextConfig)contextForRuleSetEither.right().get()).getProjectIds().get(0);
        return new ProjectContextResponse(projectId);
    }

    public ProjectContextResponse buildFromInput(@Nonnull ApplicationUser user, @Nonnull RuleSetInput ruleSetInput) {
        ProjectContextInputImpl ruleMetadataProjectInput = ((RuleSetInputImpl)ruleSetInput).getRuleMetadata().getRuleMetadataProjectInput();
        Option<Project> project = ruleMetadataProjectInput.getProject();
        if (project.isEmpty()) {
            return new ProjectContextResponse(null);
        }
        return new ProjectContextResponse(((Project)project.get()).getId());
    }
}

