/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfThen;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.IfThenValidationResult;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.IfThenInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.IfResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.ThenResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.ValidationResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.IfResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.IfThenResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.ThenResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.ValidationResponse;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IfThenResponseBuilder {
    private final IfResponseBuilder ifResponseBuilder;
    private final ThenResponseBuilder thenResponseBuilder;
    private final ValidationResponseBuilder validationResponseBuilder;

    @Autowired
    public IfThenResponseBuilder(@Nonnull IfResponseBuilder ifResponseBuilder, @Nonnull ThenResponseBuilder thenResponseBuilder, @Nonnull ValidationResponseBuilder validationResponseBuilder) {
        Assertions.notNull((String)"ifResponseBuilder", (Object)ifResponseBuilder);
        Assertions.notNull((String)"thenResponseBuilder", (Object)thenResponseBuilder);
        Assertions.notNull((String)"validationResponseBuilder", (Object)validationResponseBuilder);
        this.validationResponseBuilder = validationResponseBuilder;
        this.ifResponseBuilder = ifResponseBuilder;
        this.thenResponseBuilder = thenResponseBuilder;
    }

    public List<IfThenResponse> build(@Nonnull ApplicationUser user, @Nonnull List<IfThen> ifThens, @Nonnull List<IfThenValidationResult> ifThenValidationResults) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"ifThens", ifThens);
        Assertions.notNull((String)"ifThenValidationResults", ifThenValidationResults);
        Assertions.isTrue((String)"ifThenValidationResults same size as ifThens", (ifThenValidationResults.size() == ifThens.size() ? 1 : 0) != 0);
        ArrayList ifThenResponses = Lists.newArrayList();
        for (int i = 0; i < ifThens.size(); ++i) {
            IfThen ifThen = ifThens.get(i);
            IfThenValidationResult ifThenValidationResult = ifThenValidationResults.get(i);
            ifThenResponses.add(this.build(user, ifThen, ifThenValidationResult));
        }
        return ifThenResponses;
    }

    public IfThenResponse build(@Nonnull ApplicationUser user, @Nonnull IfThen ifThen, @Nonnull IfThenValidationResult ifThenValidationResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"ifThen", (Object)ifThen);
        Assertions.notNull((String)"ifThenValidationResult", (Object)ifThenValidationResult);
        IfResponse ifResponse = this.ifResponseBuilder.build(user, ifThen.getIf(), ifThenValidationResult.getIfValidationResults());
        ThenResponse thenResponse = this.thenResponseBuilder.build(user, ifThen.getThen(), ifThenValidationResult.getThenValidationResults());
        ValidationResponse validationResponse = this.validationResponseBuilder.build(user, ifThenValidationResult.getIfThenValidationResult());
        return new IfThenResponse(ifResponse, thenResponse, validationResponse);
    }

    public List<IfThenResponse> buildFromInput(@Nonnull ApplicationUser user, @Nonnull List<IfThenInputImpl> ifThens, @Nonnull List<IfThenValidationResult> ifThenValidationResults) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"ifThens", ifThens);
        Assertions.notNull((String)"ifThenValidationResults", ifThenValidationResults);
        Assertions.isTrue((String)"ifThenValidationResults same size as ifThens", (ifThenValidationResults.size() == ifThens.size() ? 1 : 0) != 0);
        ArrayList ifThenResponses = Lists.newArrayList();
        for (int i = 0; i < ifThens.size(); ++i) {
            IfThenInputImpl ifThen = ifThens.get(i);
            IfThenValidationResult ifThenValidationResult = ifThenValidationResults.get(i);
            ifThenResponses.add(this.buildFromInput(user, ifThen, ifThenValidationResult));
        }
        return ifThenResponses;
    }

    public IfThenResponse buildFromInput(@Nonnull ApplicationUser user, @Nonnull IfThenInputImpl ifThen, @Nonnull IfThenValidationResult ifThenValidationResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"ifThen", (Object)ifThen);
        Assertions.notNull((String)"ifThenValidationResult", (Object)ifThenValidationResult);
        IfResponse ifResponse = this.ifResponseBuilder.buildFromInput(user, ifThen.getIfInput(), ifThenValidationResult.getIfValidationResults());
        ThenResponse thenResponse = this.thenResponseBuilder.buildFromInput(user, ifThen.getThenInput(), ifThenValidationResult.getThenValidationResults());
        ValidationResponse validationResponse = this.validationResponseBuilder.build(user, ifThenValidationResult.getIfThenValidationResult());
        return new IfThenResponse(ifResponse, thenResponse, validationResponse);
    }
}

