/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.If;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfConditionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.IfValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.ComponentConfigurationInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.IfInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.IfConditionResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.ValidationResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.IfResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.ValidationResponse;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IfResponseBuilder {
    private final IfConditionResponseBuilder ifConditionResponseBuilder;
    private final ValidationResponseBuilder validationResponseBuilder;

    @Autowired
    public IfResponseBuilder(@Nonnull IfConditionResponseBuilder ifConditionResponseBuilder, @Nonnull ValidationResponseBuilder validationResponseBuilder) {
        Assertions.notNull((String)"ifConditionResponseBuilder", (Object)ifConditionResponseBuilder);
        Assertions.notNull((String)"validationResponseBuilder", (Object)validationResponseBuilder);
        this.validationResponseBuilder = validationResponseBuilder;
        this.ifConditionResponseBuilder = ifConditionResponseBuilder;
    }

    public IfResponse build(@Nonnull ApplicationUser user, @Nonnull If ifCondition, @Nonnull IfValidationResult ifValidationResult) {
        List ifConditionConfigurations = ifCondition.getIfConditionConfigurations();
        ValidationResponse validationResponse = this.validationResponseBuilder.build(user, ifValidationResult.getIfValidationResult());
        ArrayList ifConditionResponses = Lists.newArrayList();
        for (int i = 0; i < ifConditionConfigurations.size(); ++i) {
            IfConditionConfiguration ifConditionConfiguration = (IfConditionConfiguration)ifConditionConfigurations.get(i);
            ValidationResult validationResult = (ValidationResult)ifValidationResult.getIfConditionValidationResult().get(i);
            ifConditionResponses.add(this.ifConditionResponseBuilder.buildIfCondition(user, ifConditionConfiguration, validationResult));
        }
        return new IfResponse(ifConditionResponses, validationResponse);
    }

    public IfResponse buildFromInput(@Nonnull ApplicationUser user, @Nonnull IfInputImpl ifInputImpl, @Nonnull IfValidationResult ifValidationResult) {
        List<ComponentConfigurationInputImpl> ifConditionConfigurations = ifInputImpl.getIfConditionConfigurationInputs();
        ValidationResponse validationResponse = this.validationResponseBuilder.build(user, ifValidationResult.getIfValidationResult());
        ArrayList ifConditionResponses = Lists.newArrayList();
        for (int i = 0; i < ifConditionConfigurations.size(); ++i) {
            ComponentConfigurationInputImpl ifConditionConfiguration = ifConditionConfigurations.get(i);
            ValidationResult validationResult = (ValidationResult)ifValidationResult.getIfConditionValidationResult().get(i);
            ifConditionResponses.add(this.ifConditionResponseBuilder.buildIfConditionInput(user, ifConditionConfiguration, validationResult));
        }
        return new IfResponse(ifConditionResponses, validationResponse);
    }
}

