/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest.helper;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorCollectionHelper;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.BuilderService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.helper.RuleSetInputTransformer;
import com.atlassian.servicedesk.plugins.automation.internal.rest.helper.RuleSetInputTransformerHelper;
import com.atlassian.servicedesk.plugins.automation.internal.rest.request.CreateRuleSetRequest;
import com.atlassian.servicedesk.plugins.automation.internal.rest.request.RuleRequest;
import com.atlassian.servicedesk.plugins.automation.internal.rest.request.RunAsUserContextConfigRequest;
import com.atlassian.servicedesk.plugins.automation.internal.rest.request.UpdateRuleSetRequest;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleSetInputTransformerImpl
implements RuleSetInputTransformer {
    private final BuilderService builderService;
    private final UserManager userManager;
    private final ProjectService projectService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public RuleSetInputTransformerImpl(BuilderService builderService, UserManager userManager, ProjectService projectService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.builderService = builderService;
        this.userManager = userManager;
        this.projectService = projectService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public Either<AnError, RuleSetInput> requestToRuleSetInput(CreateRuleSetRequest ruleSetRequest) {
        RunAsUserContextConfigRequest runAsUserContextConfigRequest;
        Option<AnError> userNotFoundError;
        RuleSetInputBuilder builder = this.builderService.newRuleSetBuilder();
        builder.name(ruleSetRequest.getName()).description(ruleSetRequest.getDescription()).isSystemRuleSet(false).metadata().triggerFromOtherRules(ruleSetRequest.getMetadataRequest().getTriggerFromOtherRules());
        if (this.requestHasAUserContext(ruleSetRequest) && (userNotFoundError = this.checkUserContextTypeAndAddUserToBuilder(builder, runAsUserContextConfigRequest = ruleSetRequest.getMetadataRequest().getRunAsUserContextRequest(), this.isUserContextValidForCreateInput(runAsUserContextConfigRequest))).isDefined()) {
            return Either.left((Object)userNotFoundError.get());
        }
        Option projectInvalidError = this.requestHasAProjectId(ruleSetRequest).flatMap(id -> this.addProjectToBuilder(builder, (long)id));
        if (projectInvalidError.isDefined()) {
            return Either.left((Object)projectInvalidError.get());
        }
        for (RuleRequest ruleRequest : ruleSetRequest.getRuleRequests()) {
            RuleSetInputTransformerHelper.buildRulesInputFromRequest(builder.rule(), ruleRequest, this.builderService);
        }
        return Either.right((Object)builder.build());
    }

    private Option<AnError> addProjectToBuilder(RuleSetInputBuilder builder, long projectId) {
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectById(this.getUser(), Long.valueOf(projectId));
        if (!projectResult.isValid()) {
            return Option.some((Object)ErrorCollectionHelper.error((ErrorCollection)projectResult.getErrorCollection()).left().get());
        }
        builder.metadata().projectContext().project(projectResult.getProject());
        return Option.none();
    }

    @Override
    public Either<AnError, RuleSetInput> requestToRuleSetInput(UpdateRuleSetRequest updateRuleSetRequest, Long ruleSetId) {
        RunAsUserContextConfigRequest runAsUserContextConfigRequest;
        Option<AnError> userNotFoundError;
        if (updateRuleSetRequest.getId() != null && !updateRuleSetRequest.getId().equals(ruleSetId)) {
            AnError anError = new AnError(ErrorMessage.builder().message("Invalid id, failed to update").build(), Response.Status.BAD_REQUEST.getStatusCode());
            return Either.left((Object)anError);
        }
        RuleSetInputBuilder builder = this.builderService.newRuleSetBuilder();
        builder.id(ruleSetId).name(updateRuleSetRequest.getName()).description(updateRuleSetRequest.getDescription()).isSystemRuleSet(false).metadata().triggerFromOtherRules(updateRuleSetRequest.getMetadataRequest().getTriggerFromOtherRules());
        if (this.requestHasAUserContext(updateRuleSetRequest) && (userNotFoundError = this.checkUserContextTypeAndAddUserToBuilder(builder, runAsUserContextConfigRequest = updateRuleSetRequest.getMetadataRequest().getRunAsUserContextRequest(), this.isUserContextValidForUpdateInput(runAsUserContextConfigRequest))).isDefined()) {
            return Either.left((Object)userNotFoundError.get());
        }
        Option projectInvalidError = this.requestHasAProjectId(updateRuleSetRequest).flatMap(id -> this.addProjectToBuilder(builder, (long)id));
        if (projectInvalidError.isDefined()) {
            return Either.left((Object)projectInvalidError.get());
        }
        for (RuleRequest ruleRequest : updateRuleSetRequest.getRuleRequests()) {
            RuleSetInputTransformerHelper.buildRulesInputFromRequest(builder.rule(), ruleRequest, this.builderService);
        }
        return Either.right((Object)builder.build());
    }

    private Option<AnError> checkUserContextTypeAndAddUserToBuilder(RuleSetInputBuilder builder, RunAsUserContextConfigRequest runAsUserContextConfigRequest, boolean userContextIsValid) {
        String userKey;
        ApplicationUser user;
        Option<AnError> userNotAddedError;
        if (runAsUserContextConfigRequest.getType().equals("currentUser")) {
            builder.metadata().userContext().runAsCurrentUser();
        } else if (userContextIsValid && (userNotAddedError = this.addUserToBuilder(builder, user = this.userManager.getUserByKey(userKey = runAsUserContextConfigRequest.getUser().getUserKey()))).isDefined()) {
            return Option.some((Object)userNotAddedError.get());
        }
        return Option.none();
    }

    private Option<AnError> addUserToBuilder(RuleSetInputBuilder builder, ApplicationUser user) {
        if (user == null) {
            AnError userNotFoundError = new AnError(ErrorMessage.builder().message("sd.automation.error.user.not.found", "sd.automation.error.user.not.found").build(), HttpStatusCode.BAD_REQUEST);
            return Option.some((Object)userNotFoundError);
        }
        builder.metadata().userContext().runAs(user);
        return Option.none();
    }

    private boolean isUserContextValidForCreateInput(RunAsUserContextConfigRequest runAsUserContextConfigRequest) {
        return this.isUserContextValidForUpdateInput(runAsUserContextConfigRequest) && runAsUserContextConfigRequest.getUser().getUserKey() != null;
    }

    private boolean isUserContextValidForUpdateInput(RunAsUserContextConfigRequest runAsUserContextRequest) {
        return runAsUserContextRequest.getType().equals("specificUser");
    }

    private boolean requestHasAUserContext(CreateRuleSetRequest ruleSetRequest) {
        return ruleSetRequest.getMetadataRequest() != null && ruleSetRequest.getMetadataRequest().getRunAsUserContextRequest() != null;
    }

    private Option<Long> requestHasAProjectId(CreateRuleSetRequest ruleSetRequest) {
        if (ruleSetRequest.getMetadataRequest() != null) {
            return Option.option((Object)ruleSetRequest.getMetadataRequest().getProjectContextRequest().getProjectId());
        }
        return Option.none();
    }

    private boolean requestHasAUserContext(UpdateRuleSetRequest ruleSetRequest) {
        return ruleSetRequest.getMetadataRequest() != null && ruleSetRequest.getMetadataRequest().getRunAsUserContextRequest() != null;
    }

    private Option<Long> requestHasAProjectId(UpdateRuleSetRequest ruleSetRequest) {
        if (ruleSetRequest.getMetadataRequest() != null) {
            return Option.option((Object)ruleSetRequest.getMetadataRequest().getProjectContextRequest().getProjectId());
        }
        return Option.none();
    }

    protected ApplicationUser getUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }
}

