/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSetService;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.ExecutionHistoryFilter;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.ExecutionHistoryManager;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.RuleExecutionSummary;
import com.atlassian.servicedesk.plugins.automation.internal.execution.log.RuleSetAuditLogData;
import com.atlassian.servicedesk.plugins.automation.internal.execution.log.RuleSetAuditLogManager;
import com.atlassian.servicedesk.plugins.automation.internal.permission.AutomationPermissionManager;
import com.atlassian.servicedesk.plugins.automation.internal.rest.AbstractAutomationPluginResource;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.auditlog.LogResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.RuleSetAuditResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.execution.RuleExecutionResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.execution.RuleExecutionAuditLogResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.execution.RuleExecutionSummaryResponse;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/audit")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class RuleSetAuditResource
extends AbstractAutomationPluginResource {
    private static final Logger log = LoggerFactory.getLogger(RuleSetAuditResource.class);
    private final RuleExecutionResponseBuilder ruleExecutionResponseBuilder;
    private final RuleSetService ruleSetService;
    private final ExecutionHistoryManager executionHistoryManager;
    private final RuleSetAuditLogManager ruleSetAuditLogManager;
    private final RuleSetAuditResponseBuilder ruleSetAuditResponseBuilder;
    private final TimeZoneManager timeZoneManager;
    private final LocaleManager localeManager;

    public RuleSetAuditResource(@Nonnull JiraAuthenticationContext authenticationContext, @Nonnull AutomationPermissionManager automationPermissionManager, @Nonnull RuleExecutionResponseBuilder ruleExecutionResponseBuilder, @Nonnull RuleSetService ruleSetService, @Nonnull ExecutionHistoryManager executionHistoryManager, @Nonnull RuleSetAuditLogManager ruleSetAuditLogManager, @Nonnull RuleSetAuditResponseBuilder ruleSetAuditResponseBuilder, @Nonnull TimeZoneManager timeZoneManager, @Nonnull LocaleManager localeManager) {
        super(authenticationContext, automationPermissionManager);
        this.ruleExecutionResponseBuilder = ruleExecutionResponseBuilder;
        this.ruleSetService = ruleSetService;
        this.executionHistoryManager = executionHistoryManager;
        this.ruleSetAuditLogManager = ruleSetAuditLogManager;
        this.ruleSetAuditResponseBuilder = ruleSetAuditResponseBuilder;
        this.timeZoneManager = timeZoneManager;
        this.localeManager = localeManager;
    }

    @GET
    @Path(value="/ruleset/{ruleSetId}")
    public Response getRuleSetAudit(@PathParam(value="ruleSetId") long ruleSetId, @QueryParam(value="issueKeyFilter") String issueKeyFilter, @QueryParam(value="hideSuccessfulExecutions") Boolean hideSuccessfulExecutions) {
        ApplicationUser user = this.getUser();
        io.atlassian.fugue.Either<AnError, Unit> hasAdminOrProjectAdminPermission = this.hasAdminOrProjectAdminPermission();
        if (hasAdminOrProjectAdminPermission.isLeft()) {
            return this.errorResponse("automation.no.permission", (AnError)hasAdminOrProjectAdminPermission.left().get());
        }
        io.atlassian.fugue.Either ruleSetResult = StepsConverters.newerEither((Either)this.ruleSetService.getById(user, ruleSetId));
        return (Response)ruleSetResult.fold(error -> this.errorResponse("sd.automation.get.rule.set.failed", (AnError)error), ruleSet -> {
            ArrayList ruleExecutionResponses = Lists.newArrayList();
            ExecutionHistoryFilter filter = new ExecutionHistoryFilter(this.retrieveIssueKeys(issueKeyFilter), hideSuccessfulExecutions);
            List<RuleExecutionSummary> ruleExecutionSummaries = this.executionHistoryManager.getExecutionsForRule(ruleSetId, filter);
            DateTimeFormatter formatter = this.getDateFormat();
            for (RuleExecutionSummary ruleExecutionSummary : ruleExecutionSummaries) {
                RuleExecutionSummaryResponse ruleExecutionResponse = this.ruleExecutionResponseBuilder.buildSummary(user, ruleExecutionSummary, formatter);
                ruleExecutionResponses.add(ruleExecutionResponse);
            }
            RuleExecutionAuditLogResponse auditLogResponse = new RuleExecutionAuditLogResponse(ruleSet.getName(), ruleExecutionResponses);
            return Response.ok((Object)auditLogResponse).build();
        });
    }

    private List<String> retrieveIssueKeys(String issueKeyFilter) {
        if (StringUtils.isBlank((String)issueKeyFilter)) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.split((String)issueKeyFilter, (String)","));
    }

    @GET
    @Path(value="/ruleset/{ruleSetId}/issue-keys")
    public Response getRuleSetIssueKeys(@PathParam(value="ruleSetId") long ruleSetId, @QueryParam(value="searchQuery") String issueKeySearchPattern) {
        ApplicationUser user = this.getUser();
        io.atlassian.fugue.Either<AnError, Unit> hasAdminOrProjectAdminPermission = this.hasAdminOrProjectAdminPermission();
        if (hasAdminOrProjectAdminPermission.isLeft()) {
            return this.errorResponse("automation.no.permission", (AnError)hasAdminOrProjectAdminPermission.left().get());
        }
        io.atlassian.fugue.Either ruleSetResult = StepsConverters.newerEither((Either)this.ruleSetService.getById(user, ruleSetId));
        return (Response)ruleSetResult.fold(error -> this.errorResponse("sd.automation.get.rule.set.failed", (AnError)error), ruleSet -> {
            List<String> issueKeys = this.executionHistoryManager.getIssueKeysForRuleExecutions(ruleSetId, StringUtils.upperCase((String)issueKeySearchPattern));
            return Response.ok(issueKeys).build();
        });
    }

    @GET
    @Path(value="/execution/{executionId}")
    public Response getExecutionAuditEntry(@PathParam(value="executionId") long executionId) {
        io.atlassian.fugue.Either<AnError, Unit> hasAdminOrProjectAdminPermission = this.hasAdminOrProjectAdminPermission();
        if (hasAdminOrProjectAdminPermission.isLeft()) {
            return this.errorResponse("automation.no.permission", (AnError)hasAdminOrProjectAdminPermission.left().get());
        }
        Option<RuleSetAuditLogData> auditLog = this.ruleSetAuditLogManager.getAuditLogForExecution(executionId);
        LogResponse response = this.ruleSetAuditResponseBuilder.createAuditLogResponse((RuleSetAuditLogData)auditLog.get());
        return Response.ok((Object)response).build();
    }

    private DateTimeFormatter getDateFormat() {
        TimeZone timeZone = this.timeZoneManager.getLoggedInUserTimeZone();
        Locale locale = this.localeManager.getLocaleFor(this.getUser());
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG, FormatStyle.MEDIUM).withZone(timeZone.toZoneId()).withLocale(locale);
    }
}

