/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.BuilderService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.ComponentConfigurationInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation.IfValidator;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation.ThenValidator;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation.WhenValidator;
import com.atlassian.servicedesk.plugins.automation.internal.permission.AutomationPermissionManager;
import com.atlassian.servicedesk.plugins.automation.internal.rest.AbstractAutomationPluginResource;
import com.atlassian.servicedesk.plugins.automation.internal.rest.request.RuleComponentRequest;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.IfConditionResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.ThenActionResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.WhenHandlerResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.moduledata.IfConditionModuleDataListResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.moduledata.ThenActionModuleDataListResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.moduledata.WhenHandlerModuleDataListResponse;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/components")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class RuleComponentResource
extends AbstractAutomationPluginResource {
    private final IfConditionResponseBuilder ifConditionResponseBuilder;
    private final ThenActionResponseBuilder thenActionResponseBuilder;
    private final WhenHandlerResponseBuilder whenHandlerResponseBuilder;
    private final ProjectService projectService;
    private final IfValidator ifValidator;
    private final ThenValidator thenValidator;
    private final WhenValidator whenValidator;
    private final BuilderService builderService;

    @Autowired
    public RuleComponentResource(IfConditionResponseBuilder ifConditionResponseBuilder, ThenActionResponseBuilder thenActionResponseBuilder, WhenHandlerResponseBuilder whenHandlerResponseBuilder, JiraAuthenticationContext jiraAuthenticationContext, IfValidator ifValidator, ThenValidator thenValidator, WhenValidator whenValidator, BuilderService builderService, AutomationPermissionManager automationPermissionManager, ProjectService projectService) {
        super(jiraAuthenticationContext, automationPermissionManager);
        this.whenHandlerResponseBuilder = whenHandlerResponseBuilder;
        this.ifConditionResponseBuilder = ifConditionResponseBuilder;
        this.thenActionResponseBuilder = thenActionResponseBuilder;
        this.ifValidator = ifValidator;
        this.thenValidator = thenValidator;
        this.whenValidator = whenValidator;
        this.builderService = builderService;
        this.projectService = projectService;
    }

    @POST
    @Path(value="if/{projectKey}/validate")
    public Response validateIfModule(@PathParam(value="projectKey") String projectKey, RuleComponentRequest ruleComponentRequest) {
        ApplicationUser user = this.getUser();
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(user, projectKey);
        if (!projectResult.isValid()) {
            return this.errorResponse("sd.automation.error.project.not.found", projectResult.getErrorCollection());
        }
        Project project = projectResult.getProject();
        Either<AnError, Unit> canManageRuleForProject = this.canManageRuleForProject(project);
        if (canManageRuleForProject.isLeft()) {
            return this.errorResponse("automation.no.permission", (AnError)canManageRuleForProject.left().get());
        }
        ComponentConfigurationInputImpl componentConfigurationInput = this.getComponentConfigurationInput(ruleComponentRequest);
        ValidationResult validationResult = this.ifValidator.validationIfConditionInput(user, componentConfigurationInput, (Option<ProjectContext>)Option.some((Object)this.buildProjectContext(project)));
        if (!validationResult.isPassed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.ifConditionResponseBuilder.buildIfConditionInput(user, componentConfigurationInput, validationResult)).build();
        }
        return Response.ok((Object)this.ifConditionResponseBuilder.buildIfConditionInput(user, componentConfigurationInput, validationResult)).build();
    }

    @POST
    @Path(value="then/{projectKey}/validate")
    public Response validateThenModule(@PathParam(value="projectKey") String projectKey, RuleComponentRequest ruleComponentRequest) {
        ApplicationUser user = this.getUser();
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(user, projectKey);
        if (!projectResult.isValid()) {
            return this.errorResponse("sd.automation.error.project.not.found", projectResult.getErrorCollection());
        }
        Project project = projectResult.getProject();
        Either<AnError, Unit> canManageRuleForProject = this.canManageRuleForProject(project);
        if (canManageRuleForProject.isLeft()) {
            return this.errorResponse("automation.no.permission", (AnError)canManageRuleForProject.left().get());
        }
        ComponentConfigurationInputImpl componentConfigurationInput = this.getComponentConfigurationInput(ruleComponentRequest);
        ValidationResult validationResult = this.thenValidator.validationThenActionInput(user, componentConfigurationInput, (Option<ProjectContext>)Option.some((Object)this.buildProjectContext(project)), ruleComponentRequest.getEffectiveProvides());
        if (!validationResult.isPassed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.thenActionResponseBuilder.buildThenActionInput(user, componentConfigurationInput, validationResult)).build();
        }
        return Response.ok((Object)this.thenActionResponseBuilder.buildThenActionInput(user, componentConfigurationInput, validationResult)).build();
    }

    @POST
    @Path(value="when/{projectKey}/validate")
    public Response validateWhenModule(@PathParam(value="projectKey") String projectKey, RuleComponentRequest ruleComponentRequest) {
        ApplicationUser user = this.getUser();
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(user, projectKey);
        if (!projectResult.isValid()) {
            return this.errorResponse("sd.automation.error.project.not.found", projectResult.getErrorCollection());
        }
        Project project = projectResult.getProject();
        Either<AnError, Unit> canManageRuleForProject = this.canManageRuleForProject(project);
        if (canManageRuleForProject.isLeft()) {
            return this.errorResponse("automation.no.permission", (AnError)canManageRuleForProject.left().get());
        }
        ComponentConfigurationInputImpl componentConfigurationInput = this.getComponentConfigurationInput(ruleComponentRequest);
        ValidationResult validationResult = this.whenValidator.validateWhenHandlerInput(user, componentConfigurationInput, (Option<ProjectContext>)Option.some((Object)this.buildProjectContext(project)));
        if (!validationResult.isPassed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.whenHandlerResponseBuilder.buildWhenHandlerInput(user, componentConfigurationInput, validationResult)).build();
        }
        return Response.ok((Object)this.whenHandlerResponseBuilder.buildWhenHandlerInput(user, componentConfigurationInput, validationResult)).build();
    }

    @GET
    @Path(value="if")
    public Response getAllIfModules() {
        Either<AnError, Unit> hasAdminOrProjectAdminPermission = this.hasAdminOrProjectAdminPermission();
        if (hasAdminOrProjectAdminPermission.isLeft()) {
            return this.errorResponse("automation.no.permission", (AnError)hasAdminOrProjectAdminPermission.left().get());
        }
        IfConditionModuleDataListResponse ifConditionResponses = this.ifConditionResponseBuilder.buildIfConditionModuleList();
        return Response.ok((Object)ifConditionResponses).build();
    }

    @GET
    @Path(value="when")
    public Response getAllWhenModules() {
        Either<AnError, Unit> hasAdminOrProjectAdminPermission = this.hasAdminOrProjectAdminPermission();
        if (hasAdminOrProjectAdminPermission.isLeft()) {
            return this.errorResponse("automation.no.permission", (AnError)hasAdminOrProjectAdminPermission.left().get());
        }
        WhenHandlerModuleDataListResponse whenHandlerResponses = this.whenHandlerResponseBuilder.buildWhenHandlerModuleList();
        return Response.ok((Object)whenHandlerResponses).build();
    }

    @GET
    @Path(value="then")
    public Response getAllThenModules() {
        Either<AnError, Unit> hasAdminOrProjectAdminPermission = this.hasAdminOrProjectAdminPermission();
        if (hasAdminOrProjectAdminPermission.isLeft()) {
            return this.errorResponse("automation.no.permission", (AnError)hasAdminOrProjectAdminPermission.left().get());
        }
        ThenActionModuleDataListResponse thenActionResponses = this.thenActionResponseBuilder.buildAllThenActionModuleList();
        return Response.ok((Object)thenActionResponses).build();
    }

    private ComponentConfigurationInputImpl getComponentConfigurationInput(RuleComponentRequest ruleComponentRequest) {
        String moduleKey = ruleComponentRequest.getModuleKey();
        ConfigurationData configurationData = this.builderService.newConfigurationDataBuilder().putAll(ruleComponentRequest.getData()).build();
        return new ComponentConfigurationInputImpl((Option<String>)Option.option((Object)moduleKey), configurationData);
    }
}

