/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.project.ProjectRunAsUserContextConfigService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.user.RunAsSpecificUserContextConfigImpl;
import com.atlassian.servicedesk.plugins.automation.internal.permission.AutomationPermissionManager;
import com.atlassian.servicedesk.plugins.automation.internal.rest.AbstractAutomationPluginResource;
import com.atlassian.servicedesk.plugins.automation.internal.rest.request.RunAsUserContextConfigRequest;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.RunAsUserContextConfigResponseBuilder;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="/project/{projectKey}/runAsUser")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ProjectRunAsUserContextConfigResource
extends AbstractAutomationPluginResource {
    private final ProjectService projectService;
    private final ProjectRunAsUserContextConfigService projectRunAsUserContextConfigService;
    private final RunAsUserContextConfigResponseBuilder runAsUserContextConfigResponseBuilder;

    public ProjectRunAsUserContextConfigResource(@Nonnull JiraAuthenticationContext authenticationContext, @Nonnull AutomationPermissionManager automationPermissionManager, @Nonnull ProjectService projectService, @Nonnull ProjectRunAsUserContextConfigService projectRunAsUserContextConfigService, @Nonnull RunAsUserContextConfigResponseBuilder runAsUserContextConfigResponseBuilder) {
        super(authenticationContext, automationPermissionManager);
        this.projectService = projectService;
        this.projectRunAsUserContextConfigService = projectRunAsUserContextConfigService;
        this.runAsUserContextConfigResponseBuilder = runAsUserContextConfigResponseBuilder;
    }

    @GET
    public Response getRunAsUserProjectContextConfig(@PathParam(value="projectKey") String projectKey) {
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(this.getUser(), projectKey);
        if (!projectResult.isValid()) {
            return this.notFoundRequest("sd.automation.error.project.not.found", projectResult.getErrorCollection());
        }
        Project project = projectResult.getProject();
        io.atlassian.fugue.Either getOperationResult = StepsConverters.newerEither((Either)this.projectRunAsUserContextConfigService.getContextConfigForProject(this.getUser(), project)).map(StepsConverters::newerOption);
        if (getOperationResult.isLeft()) {
            return this.errorResponse("sd.automation.error.run.as.user.project.context.get.error", (AnError)getOperationResult.left().get());
        }
        Option runAsUserProjectContextConfigOpt = (Option)getOperationResult.right().get();
        return this.ok(this.runAsUserContextConfigResponseBuilder.buildProjectSettingsResponse(project, (Option<RunAsUserContextConfig>)runAsUserProjectContextConfigOpt, false));
    }

    @PUT
    public Response setRunAsUserProjectContextConfig(@PathParam(value="projectKey") String projectKey, RunAsUserContextConfigRequest request) {
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(this.getUser(), projectKey);
        if (!projectResult.isValid()) {
            return this.notFoundRequest("sd.automation.error.project.not.found", projectResult.getErrorCollection());
        }
        Project project = projectResult.getProject();
        if (request.getUser() == null || StringUtils.isBlank((String)request.getUser().getUserKey())) {
            return this.badRequest("sd.automation.error.run.as.user.project.context.error.invalid.request");
        }
        String userKeyRequest = request.getUser().getUserKey();
        RunAsSpecificUserContextConfigImpl runAsSpecificUserContextConfig = new RunAsSpecificUserContextConfigImpl(userKeyRequest);
        io.atlassian.fugue.Either setOperationResult = StepsConverters.newerEither((Either)this.projectRunAsUserContextConfigService.setRunAsUserContextConfigForProject(this.getUser(), project, (RunAsUserContextConfig)runAsSpecificUserContextConfig));
        if (setOperationResult.isLeft()) {
            return this.errorResponse("sd.automation.error.run.as.user.project.context.update.error", (AnError)setOperationResult.left().get());
        }
        io.atlassian.fugue.Either getOperationResult = StepsConverters.newerEither((Either)this.projectRunAsUserContextConfigService.getContextConfigForProject(this.getUser(), project)).map(StepsConverters::newerOption);
        if (getOperationResult.isLeft()) {
            return this.errorResponse("sd.automation.error.run.as.user.project.context.get.error", (AnError)getOperationResult.left().get());
        }
        Option runAsUserProjectContextConfigOpt = (Option)getOperationResult.right().get();
        return this.ok(this.runAsUserContextConfigResponseBuilder.buildProjectSettingsResponse(project, (Option<RunAsUserContextConfig>)runAsUserProjectContextConfigOpt, false));
    }

    @DELETE
    public Response deleteRunAsUserProjectContextConfig(@PathParam(value="projectKey") String projectKey) {
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(this.getUser(), projectKey);
        if (!projectResult.isValid()) {
            return this.notFoundRequest("sd.automation.error.project.not.found", projectResult.getErrorCollection());
        }
        Project project = projectResult.getProject();
        io.atlassian.fugue.Either setOperationResult = StepsConverters.newerEither((Either)this.projectRunAsUserContextConfigService.deleteContextConfigForProject(this.getUser(), project));
        if (setOperationResult.isLeft()) {
            return this.errorResponse("sd.automation.error.run.as.user.project.context.delete.error", (AnError)setOperationResult.left().get());
        }
        return this.noContent();
    }

    @PUT
    @Path(value="/defaultToCurrentUserIfEmpty")
    public Response defaultToCurrentUserIfEmpty(@PathParam(value="projectKey") String projectKey) {
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(this.getUser(), projectKey);
        if (!projectResult.isValid()) {
            return this.notFoundRequest("sd.automation.error.project.not.found", projectResult.getErrorCollection());
        }
        Project project = projectResult.getProject();
        io.atlassian.fugue.Either getOperationResult = StepsConverters.newerEither((Either)this.projectRunAsUserContextConfigService.getContextConfigForProject(this.getUser(), project)).map(StepsConverters::newerOption);
        if (getOperationResult.isLeft()) {
            return this.errorResponse("sd.automation.error.run.as.user.project.context.get.error", (AnError)getOperationResult.left().get());
        }
        Option runAsUserProjectContextConfigOpt = (Option)getOperationResult.right().get();
        if (runAsUserProjectContextConfigOpt.isDefined()) {
            return this.ok(this.runAsUserContextConfigResponseBuilder.buildProjectSettingsResponse(project, (Option<RunAsUserContextConfig>)runAsUserProjectContextConfigOpt, false));
        }
        RunAsSpecificUserContextConfigImpl runAsSpecificUserContextConfig = new RunAsSpecificUserContextConfigImpl(this.getUser().getKey());
        io.atlassian.fugue.Either updateResult = StepsConverters.newerEither((Either)this.projectRunAsUserContextConfigService.setRunAsUserContextConfigForProject(this.getUser(), project, (RunAsUserContextConfig)runAsSpecificUserContextConfig));
        if (updateResult.isLeft()) {
            return this.errorResponse("sd.automation.run.as.user.setting.auto.set.failed", (AnError)updateResult.left().get());
        }
        getOperationResult = StepsConverters.newerEither((Either)this.projectRunAsUserContextConfigService.getContextConfigForProject(this.getUser(), project)).map(StepsConverters::newerOption);
        if (getOperationResult.isLeft()) {
            return this.errorResponse("sd.automation.error.run.as.user.project.context.get.error", (AnError)getOperationResult.left().get());
        }
        runAsUserProjectContextConfigOpt = (Option)getOperationResult.right().get();
        return this.ok(this.runAsUserContextConfigResponseBuilder.buildProjectSettingsResponse(project, (Option<RunAsUserContextConfig>)runAsUserProjectContextConfigOpt, true));
    }
}

