/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.ExecutionHistoryCleanerJobRunner;
import com.atlassian.servicedesk.plugins.automation.internal.permission.AutomationPermissionManager;
import com.atlassian.servicedesk.plugins.automation.internal.rest.AbstractAutomationPluginResource;
import io.atlassian.fugue.Either;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@Path(value="/historycleanup")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ExecutionHistoryCleanerResource
extends AbstractAutomationPluginResource {
    private final ExecutionHistoryCleanerJobRunner executionHistoryCleanerJobRunner;

    protected ExecutionHistoryCleanerResource(@Nonnull JiraAuthenticationContext jiraAuthenticationContext, @Nonnull AutomationPermissionManager automationPermissionManager, @Nonnull ExecutionHistoryCleanerJobRunner executionHistoryCleanerJobRunner) {
        super(jiraAuthenticationContext, automationPermissionManager);
        this.executionHistoryCleanerJobRunner = executionHistoryCleanerJobRunner;
    }

    @POST
    public Response cleanupHistoryData() {
        Either result = this.hasAdminOrProjectAdminPermission().map(unit -> this.executionHistoryCleanerJobRunner.cleanHistory());
        return (Response)result.fold(error -> this.errorResponse("sd.automation.cleanup.history.error", (AnError)error), deletedEntries -> Response.ok((Object)new CleanupResult((long)deletedEntries)).build());
    }

    @JsonAutoDetect
    private static class CleanupResult {
        private final long deletedEntries;

        CleanupResult(long deletedEntries) {
            this.deletedEntries = deletedEntries;
        }

        public long getDeletedEntries() {
            return this.deletedEntries;
        }
    }
}

