/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.module;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.RuleInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerManager;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerProvidesManager;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.MutablePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WhenHandlerProvidesManagerImpl
implements WhenHandlerProvidesManager {
    private final WhenHandlerManager whenHandlerManager;

    @Autowired
    public WhenHandlerProvidesManagerImpl(WhenHandlerManager whenHandlerManager) {
        this.whenHandlerManager = whenHandlerManager;
    }

    @Override
    public Either<? extends ModuleAccessError, Set<String>> retrieveProvides(@Nonnull ApplicationUser user, @Nonnull Rule rule) {
        return this.retrieveProvidesOfAllHandlers(user, rule).map(this::interSectProvides);
    }

    @Override
    public Either<? extends ModuleAccessError, Set<String>> retrieveProvides(@Nonnull ApplicationUser user, @Nonnull RuleInputImpl rule) {
        return rule.getWhenInputs().getWhenHandlerConfigurations().stream().map(config -> this.retrieveProvidesFromConfiguration(user, config.getModuleKey(), config.getData())).collect(new ProvidesCollector()).map(this::interSectProvides);
    }

    private Either<? extends ModuleAccessError, List<Set<String>>> retrieveProvidesOfAllHandlers(@Nonnull ApplicationUser user, @Nonnull Rule rule) {
        return rule.getWhen().getWhenHandlerConfigurations().stream().map(config -> this.retrieveProvidesFromConfiguration(user, (Option<String>)Option.some((Object)config.getModuleKey()), config.getData())).collect(new ProvidesCollector());
    }

    private Either<? extends ModuleAccessError, Set<String>> retrieveProvidesFromConfiguration(@Nonnull ApplicationUser user, @Nonnull Option<String> moduleKey, @Nonnull ConfigurationData data) {
        if (moduleKey.isEmpty()) {
            return Either.right(Collections.emptySet());
        }
        return this.whenHandlerManager.getConfiguredWhenHandlerData(user, (String)moduleKey.get(), data).map(handlerData -> handlerData.getWhenHandlerModuleData().getProvides());
    }

    @VisibleForTesting
    Set<String> interSectProvides(List<Set<String>> providesOfAllWhenHandlers) {
        if (providesOfAllWhenHandlers.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet provides = new HashSet(providesOfAllWhenHandlers.get(0));
        providesOfAllWhenHandlers.forEach(provides::retainAll);
        return Collections.unmodifiableSet(provides);
    }

    private class ProvidesCollector
    implements Collector<Either<? extends ModuleAccessError, Set<String>>, MutablePair<Option<? extends ModuleAccessError>, List<Set<String>>>, Either<? extends ModuleAccessError, List<Set<String>>>> {
        private ProvidesCollector() {
        }

        @Override
        public Supplier<MutablePair<Option<? extends ModuleAccessError>, List<Set<String>>>> supplier() {
            return () -> new MutablePair((Object)Option.none(), new ArrayList());
        }

        @Override
        public BiConsumer<MutablePair<Option<? extends ModuleAccessError>, List<Set<String>>>, Either<? extends ModuleAccessError, Set<String>>> accumulator() {
            return (optionListPair, setEither) -> {
                if (((Option)optionListPair.getLeft()).isEmpty()) {
                    if (setEither.isLeft()) {
                        optionListPair.setLeft((Object)Option.some((Object)setEither.left().get()));
                    } else {
                        ((List)optionListPair.getRight()).add(setEither.right().get());
                    }
                }
            };
        }

        @Override
        public BinaryOperator<MutablePair<Option<? extends ModuleAccessError>, List<Set<String>>>> combiner() {
            return (optionListPair, optionListPair2) -> {
                if (((Option)optionListPair.getLeft()).isDefined()) {
                    return optionListPair;
                }
                if (((Option)optionListPair2.getLeft()).isDefined()) {
                    return optionListPair2;
                }
                ArrayList list = new ArrayList((Collection)optionListPair.getRight());
                list.addAll((Collection)optionListPair2.getRight());
                return new MutablePair((Object)Option.none(), list);
            };
        }

        @Override
        public Function<MutablePair<Option<? extends ModuleAccessError>, List<Set<String>>>, Either<? extends ModuleAccessError, List<Set<String>>>> finisher() {
            return optionListMutablePair -> {
                if (((Option)optionListMutablePair.getLeft()).isDefined()) {
                    return Either.left((Object)((Option)optionListMutablePair.getLeft()).get());
                }
                return Either.right(Collections.unmodifiableList((List)optionListMutablePair.getRight()));
            };
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }
}

