/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.module;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.ozymandias.PluginPointFunction;
import com.atlassian.ozymandias.SafeAccessViaPluginAccessor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ThenActionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation.param.ThenActionValidationParamImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.visualiser.param.RuleComponentVisualiserParamImpl;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.condition.ConditionAwarePluginPointFunction;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.AsyncThenCommand;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.AsyncThenExecutorDelegator;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.param.ThenActionParamImpl;
import com.atlassian.servicedesk.plugins.automation.internal.module.RuleComponentHelper;
import com.atlassian.servicedesk.plugins.automation.internal.module.ThenActionData;
import com.atlassian.servicedesk.plugins.automation.internal.module.ThenActionDisplayData;
import com.atlassian.servicedesk.plugins.automation.internal.module.ThenActionManager;
import com.atlassian.servicedesk.plugins.automation.internal.module.ThenActionModuleData;
import com.atlassian.servicedesk.plugins.automation.internal.spi.descriptors.ThenActionModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.AsyncThenAction;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenAction;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenActionValidator;
import com.atlassian.servicedesk.plugins.automation.spi.visualiser.RuleComponentVisualiser;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Options;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ThenActionManagerImpl
implements ThenActionManager {
    private static final Logger log = LoggerFactory.getLogger(ThenActionManagerImpl.class);
    private final PluginAccessor pluginAccessor;
    private final AsyncThenExecutorDelegator asyncThenExecutor;

    @Autowired
    public ThenActionManagerImpl(@Nonnull PluginAccessor pluginAccessor, @Nonnull AsyncThenExecutorDelegator asyncThenExecutor) {
        Assertions.notNull((String)"pluginAccessor", (Object)pluginAccessor);
        Assertions.notNull((String)"asyncThenExecutor", (Object)asyncThenExecutor);
        this.pluginAccessor = pluginAccessor;
        this.asyncThenExecutor = asyncThenExecutor;
    }

    @Override
    @Nonnull
    public List<ThenActionModuleData> getThenActionModuleDataList() {
        SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
        RetrieveThenActionPluginPointVisitor retrieveThenActionPluginPointVisitor = new RetrieveThenActionPluginPointVisitor();
        List optionList = safeAccessor.forType(ThenActionModuleDescriptor.class, (PluginPointFunction)retrieveThenActionPluginPointVisitor);
        return Lists.newArrayList((Iterable)Options.flatten((Iterable)optionList));
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<? extends ModuleAccessError, ThenActionData> getConfiguredThenActionData(final @Nonnull ApplicationUser user, @Nonnull String moduleKey, final @Nonnull ConfigurationData thenActionConfigurationData) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"moduleKey", (Object)moduleKey);
        Assertions.notNull((String)"thenActionConfigurationData", (Object)thenActionConfigurationData);
        SafeAccessViaPluginAccessor safeAccessViaPluginAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
        io.atlassian.fugue.Either validatorRetrievalResult = StepsConverters.newerEither((Either)safeAccessViaPluginAccessor.forKey(moduleKey, ThenActionModuleDescriptor.class, (PluginPointFunction)new ConditionAwarePluginPointFunction<ThenActionModuleDescriptor, ThenAction, io.atlassian.fugue.Option<ThenActionData>>(){

            @Override
            protected io.atlassian.fugue.Option<ThenActionData> onModuleShouldDisplay(ThenActionModuleDescriptor moduleDescriptor, ThenAction module) {
                return io.atlassian.fugue.Option.some((Object)ThenActionManagerImpl.this.getThenActionData(user, thenActionConfigurationData, moduleDescriptor));
            }

            @Override
            protected io.atlassian.fugue.Option<ThenActionData> onModuleShouldNotDisplay(ThenActionModuleDescriptor moduleDescriptor, ThenAction module) {
                return io.atlassian.fugue.Option.none();
            }
        }));
        return RuleComponentHelper.mapToModuleNotFound(validatorRetrievalResult);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<? extends ModuleAccessError, ValidationResult> validateThenAction(final @Nonnull ApplicationUser userToValidateWith, final @Nonnull ThenActionConfiguration componentConfiguration, final @Nonnull io.atlassian.fugue.Option<ProjectContext> projectContext, final @Nonnull Set<String> provides) {
        Assertions.notNull((String)"userToValidateWith", (Object)userToValidateWith);
        Assertions.notNull((String)"componentConfiguration", (Object)componentConfiguration);
        Assertions.notNull((String)"provides", provides);
        SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
        io.atlassian.fugue.Either validatorRetrievalResult = StepsConverters.newerEither((Either)safeAccessor.forKey(componentConfiguration.getModuleKey(), ThenActionModuleDescriptor.class, (PluginPointFunction)new ConditionAwarePluginPointFunction<ThenActionModuleDescriptor, ThenAction, io.atlassian.fugue.Option<ValidationResult>>(){

            @Override
            protected io.atlassian.fugue.Option<ValidationResult> onModuleShouldDisplay(ThenActionModuleDescriptor moduleDescriptor, ThenAction module) {
                return io.atlassian.fugue.Option.some((Object)ThenActionManagerImpl.this.onThenActionModule(userToValidateWith, componentConfiguration, moduleDescriptor, (io.atlassian.fugue.Option<ProjectContext>)projectContext, provides));
            }

            @Override
            protected io.atlassian.fugue.Option<ValidationResult> onModuleShouldNotDisplay(ThenActionModuleDescriptor moduleDescriptor, ThenAction module) {
                return io.atlassian.fugue.Option.none();
            }
        }));
        return RuleComponentHelper.mapToModuleNotFound(validatorRetrievalResult);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<? extends ModuleAccessError, io.atlassian.fugue.Either<ThenActionError, RuleMessage>> executeThenAction(final @Nonnull ApplicationUser user, final @Nonnull ThenActionConfiguration actionConfiguration, final @Nonnull RuleMessage ruleMessage) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"actionConfiguration is required", (Object)actionConfiguration);
        Assertions.notNull((String)"ruleMessage is required", (Object)ruleMessage);
        SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
        io.atlassian.fugue.Either ruleMessageResult = StepsConverters.newerEither((Either)safeAccessor.forKey(actionConfiguration.getModuleKey(), ThenActionModuleDescriptor.class, (PluginPointFunction)new ConditionAwarePluginPointFunction<ThenActionModuleDescriptor, ThenAction, io.atlassian.fugue.Option<io.atlassian.fugue.Either<ThenActionError, RuleMessage>>>(){

            @Override
            protected io.atlassian.fugue.Option<io.atlassian.fugue.Either<ThenActionError, RuleMessage>> onModuleShouldDisplay(ThenActionModuleDescriptor moduleDescriptor, ThenAction thenAction) {
                ThenActionParamImpl thenActionParam = new ThenActionParamImpl(user, actionConfiguration, ruleMessage);
                if (thenAction instanceof AsyncThenAction) {
                    log.debug("Invoking ThenAction {} asynchronously", (Object)thenAction.getClass().getName());
                    return io.atlassian.fugue.Option.some(ThenActionManagerImpl.this.asyncThenExecutor.run(new AsyncThenCommand(thenAction, thenActionParam)));
                }
                log.debug("Invoking ThenAction {} synchronously", (Object)thenAction.getClass().getName());
                return io.atlassian.fugue.Option.some((Object)thenAction.invoke((ThenAction.ThenActionParam)thenActionParam)).map(StepsConverters::newerEither);
            }

            @Override
            protected io.atlassian.fugue.Option<io.atlassian.fugue.Either<ThenActionError, RuleMessage>> onModuleShouldNotDisplay(ThenActionModuleDescriptor moduleDescriptor, ThenAction module) {
                return io.atlassian.fugue.Option.none();
            }
        }));
        return RuleComponentHelper.mapToModuleNotFound(ruleMessageResult);
    }

    private ThenActionData getThenActionData(ApplicationUser user, ConfigurationData configurationData, ThenActionModuleDescriptor thenActionModuleDescriptor) {
        io.atlassian.fugue.Option displayLabel;
        String displayName;
        ThenActionModuleData thenActionModuleData = this.buildThenActionModuleData(thenActionModuleDescriptor);
        io.atlassian.fugue.Option visualiserOption = StepsConverters.newerOption(thenActionModuleDescriptor.getVisualiser());
        if (visualiserOption.isDefined()) {
            RuleComponentVisualiserParamImpl ruleComponentVisualiserParam = new RuleComponentVisualiserParamImpl(user, configurationData);
            displayName = (String)Assertions.notNull((String)"visualiser name cannot be null", (Object)((RuleComponentVisualiser)visualiserOption.get()).getName((RuleComponentVisualiser.RuleComponentVisualiserParam)ruleComponentVisualiserParam));
            displayLabel = StepsConverters.newerOption((Option)((Option)Assertions.notNull((String)"visualiser label cannot be null", (Object)((RuleComponentVisualiser)visualiserOption.get()).getLabel((RuleComponentVisualiser.RuleComponentVisualiserParam)ruleComponentVisualiserParam))));
        } else {
            displayName = (String)Assertions.notNull((String)"name cannot be null", (Object)thenActionModuleDescriptor.getName());
            displayLabel = io.atlassian.fugue.Option.none();
        }
        ThenActionDisplayData thenActionDisplayData = new ThenActionDisplayData(displayName, (io.atlassian.fugue.Option<String>)displayLabel);
        return new ThenActionData(thenActionModuleData, thenActionDisplayData);
    }

    private ThenActionModuleData buildThenActionModuleData(@Nonnull ThenActionModuleDescriptor moduleDescriptor) {
        return new ThenActionModuleData(moduleDescriptor.getCompleteKey(), moduleDescriptor.getName(), (io.atlassian.fugue.Option<String>)StepsConverters.newerOption(moduleDescriptor.getIconClass()), (io.atlassian.fugue.Option<String>)StepsConverters.newerOption(moduleDescriptor.getWebFormModule()), moduleDescriptor.getRequires());
    }

    private ValidationResult onThenActionModule(ApplicationUser userToValidateWith, ThenActionConfiguration componentConfiguration, ThenActionModuleDescriptor descriptor, io.atlassian.fugue.Option<ProjectContext> projectContext, Set<String> provides) {
        io.atlassian.fugue.Option validator = StepsConverters.newerOption(descriptor.getValidator());
        if (validator.isDefined()) {
            ThenActionValidationParamImpl thenActionValidationParam = new ThenActionValidationParamImpl(userToValidateWith, componentConfiguration, (Option<ProjectContext>)StepsConverters.olderOption(projectContext), provides);
            return ((ThenActionValidator)validator.get()).validate((ThenActionValidator.ThenActionValidationParam)thenActionValidationParam);
        }
        return ValidationResult.PASSED();
    }

    private class RetrieveThenActionPluginPointVisitor
    extends ConditionAwarePluginPointFunction<ThenActionModuleDescriptor, ThenAction, io.atlassian.fugue.Option<ThenActionModuleData>> {
        private RetrieveThenActionPluginPointVisitor() {
        }

        @Override
        protected io.atlassian.fugue.Option<ThenActionModuleData> onModuleShouldDisplay(ThenActionModuleDescriptor moduleDescriptor, ThenAction module) {
            return io.atlassian.fugue.Option.some((Object)ThenActionManagerImpl.this.buildThenActionModuleData(moduleDescriptor));
        }

        @Override
        protected io.atlassian.fugue.Option<ThenActionModuleData> onModuleShouldNotDisplay(ThenActionModuleDescriptor moduleDescriptor, ThenAction module) {
            return io.atlassian.fugue.Option.none();
        }
    }
}

