/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.module;

import com.atlassian.ozymandias.PluginPointVisitor;
import com.atlassian.ozymandias.SafeAccessViaPluginAccessor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.RuleExecutionPreprocessorModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.param.PreprocessorParamsImpl;
import com.atlassian.servicedesk.plugins.automation.internal.module.RuleExecutionPreprocessorManager;
import com.atlassian.servicedesk.plugins.automation.internal.spi.execution.RuleExecutionPreprocessor;
import com.atlassian.util.concurrent.Assertions;
import io.atlassian.fugue.Either;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleExecutionPreprocessorManagerImpl
implements RuleExecutionPreprocessorManager {
    private final PluginAccessor pluginAccessor;

    @Autowired
    public RuleExecutionPreprocessorManagerImpl(@Nonnull PluginAccessor pluginAccessor) {
        Assertions.notNull((String)"pluginAccess", (Object)pluginAccessor);
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public Either<AnError, RuleMessage> preprocess(RuleMessage ruleMessage) {
        SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
        PreProcessMessageVisitor visitor = new PreProcessMessageVisitor(ruleMessage);
        safeAccessor.forType(RuleExecutionPreprocessorModuleDescriptor.class, (PluginPointVisitor)visitor);
        return visitor.getResult();
    }

    private class PreProcessMessageVisitor
    implements PluginPointVisitor<RuleExecutionPreprocessorModuleDescriptor, RuleExecutionPreprocessor> {
        Either<AnError, RuleMessage> preprocessResult;

        PreProcessMessageVisitor(RuleMessage ruleMessage) {
            this.preprocessResult = Either.right((Object)ruleMessage);
        }

        public void visit(RuleExecutionPreprocessorModuleDescriptor ruleExecutionPreprocessorModuleDescriptor, RuleExecutionPreprocessor ruleExecutionPreprocessor) {
            if (this.preprocessResult.isRight()) {
                RuleMessage ruleMessage = (RuleMessage)this.preprocessResult.right().get();
                PreprocessorParamsImpl preprocessorParams = new PreprocessorParamsImpl(ruleMessage);
                this.preprocessResult = StepsConverters.newerEither(ruleExecutionPreprocessor.preprocess(preprocessorParams));
            }
        }

        public Either<AnError, RuleMessage> getResult() {
            return this.preprocessResult;
        }
    }
}

