/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.module;

import com.atlassian.ozymandias.PluginPointFunction;
import com.atlassian.ozymandias.SafeAccessViaPluginAccessor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.RuleExecutionInterceptorModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.internal.module.RuleExecutionInterceptorManager;
import com.atlassian.servicedesk.plugins.automation.internal.spi.execution.RuleExecutionInterceptor;
import com.atlassian.util.concurrent.Assertions;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleExecutionInterceptorManagerImpl
implements RuleExecutionInterceptorManager {
    private static final Logger LOG = LoggerFactory.getLogger(RuleExecutionInterceptorManagerImpl.class);
    private final PluginAccessor pluginAccessor;

    @Autowired
    public RuleExecutionInterceptorManagerImpl(@Nonnull PluginAccessor pluginAccessor) {
        Assertions.notNull((String)"pluginAccess", (Object)pluginAccessor);
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public void runInterceptors(RuleExecutionInterceptor.RuleExecutionParam param, RuleExecutionInterceptorManager.FinalCallback<RuleExecutionInterceptor.RuleExecutionParam> callback) {
        try {
            SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
            FetchModuleVisitor visitor = new FetchModuleVisitor();
            List interceptors = safeAccessor.forType(RuleExecutionInterceptorModuleDescriptor.class, (PluginPointFunction)visitor);
            this.runInterceptors(param, interceptors, callback);
        }
        catch (Exception e) {
            LOG.warn("Rule execution failed", (Throwable)e);
        }
    }

    @Override
    public void runInterceptors(RuleExecutionInterceptor.WhenExecutionParam param, RuleExecutionInterceptorManager.FinalCallback<RuleExecutionInterceptor.WhenExecutionParam> callback) {
        try {
            SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
            FetchModuleVisitor visitor = new FetchModuleVisitor();
            List interceptors = safeAccessor.forType(RuleExecutionInterceptorModuleDescriptor.class, (PluginPointFunction)visitor);
            this.runInterceptors(param, interceptors, callback);
        }
        catch (Exception e) {
            LOG.warn("Rule execution failed", (Throwable)e);
        }
    }

    private <T> void runInterceptors(T param, List<RuleExecutionInterceptor> interceptors, RuleExecutionInterceptorManager.FinalCallback<T> callback) {
        if (interceptors.isEmpty()) {
            callback.doExecute(param);
        } else {
            RuleExecutionInterceptor top = interceptors.get(0);
            List<RuleExecutionInterceptor> rest = interceptors.subList(1, interceptors.size());
            if (param instanceof RuleExecutionInterceptor.RuleExecutionParam) {
                top.doIntercept((RuleExecutionInterceptor.RuleExecutionParam)param, new TailInterceptorChain<T>(param, rest, callback));
            } else if (param instanceof RuleExecutionInterceptor.WhenExecutionParam) {
                top.doIntercept((RuleExecutionInterceptor.WhenExecutionParam)param, new TailInterceptorChain<T>(param, rest, callback));
            }
        }
    }

    class TailInterceptorChain<T>
    implements RuleExecutionInterceptor.InterceptorChain {
        private final T param;
        private final List<RuleExecutionInterceptor> interceptors;
        private final RuleExecutionInterceptorManager.FinalCallback<T> callback;

        TailInterceptorChain(T param, List<RuleExecutionInterceptor> interceptors, RuleExecutionInterceptorManager.FinalCallback<T> callback) {
            this.param = param;
            this.interceptors = interceptors;
            this.callback = callback;
        }

        @Override
        public void next() {
            RuleExecutionInterceptorManagerImpl.this.runInterceptors(this.param, this.interceptors, this.callback);
        }
    }

    private class FetchModuleVisitor
    implements PluginPointFunction<RuleExecutionInterceptorModuleDescriptor, RuleExecutionInterceptor, RuleExecutionInterceptor> {
        private FetchModuleVisitor() {
        }

        public RuleExecutionInterceptor onModule(RuleExecutionInterceptorModuleDescriptor moduleDescriptor, RuleExecutionInterceptor interceptor) {
            return interceptor;
        }
    }
}

