/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.module;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.ozymandias.PluginPointFunction;
import com.atlassian.ozymandias.SafeAccessViaPluginAccessor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.ozymandias.error.ModuleNotFoundError;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.blueprint.BlueprintDetails;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.internal.blueprint.BlueprintDetailsImpl;
import com.atlassian.servicedesk.plugins.automation.internal.blueprint.BlueprintHelpImpl;
import com.atlassian.servicedesk.plugins.automation.internal.blueprint.BlueprintParamImpl;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.BlueprintModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.condition.ConditionAwarePluginPointFunction;
import com.atlassian.servicedesk.plugins.automation.internal.module.BlueprintManager;
import com.atlassian.servicedesk.plugins.automation.internal.module.BlueprintModuleData;
import com.atlassian.servicedesk.plugins.automation.spi.blueprint.Blueprint;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Options;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BlueprintManagerImpl
implements BlueprintManager {
    private final PluginAccessor pluginAccessor;
    private final ErrorResultHelper errorResultHelper;
    private final I18nHelper i18nHelper;
    private final SoyTemplateRenderer soyRenderer;
    private static final String PLUGIN_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-plugin";
    private static final String DEFAULT_BLUEPRINT_HELP_TEMPLATE = "blueprint-help-resources/ServiceDesk.Templates.Agent.Settings.Blueprints.Help.Default.defaultHelp";
    private static final String DEFAULT_BLUEPRINT_HELP_FULL_ADDRESS = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-plugin:blueprint-help-resources/ServiceDesk.Templates.Agent.Settings.Blueprints.Help.Default.defaultHelp";
    private final Logger log = LoggerFactory.getLogger(BlueprintManagerImpl.class);

    @Autowired
    public BlueprintManagerImpl(PluginAccessor pluginAccessor, ErrorResultHelper errorResultHelper, I18nHelper i18nHelper, SoyTemplateRenderer soyRenderer) {
        this.pluginAccessor = pluginAccessor;
        this.errorResultHelper = errorResultHelper;
        this.i18nHelper = i18nHelper;
        this.soyRenderer = soyRenderer;
    }

    @Override
    public List<BlueprintModuleData> getBlueprintModuleDataList(@Nonnull ApplicationUser user, @Nonnull ProjectContext projectContext) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"projectContext", (Object)projectContext);
        SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
        BlueprintParamImpl blueprintParam = new BlueprintParamImpl(user, projectContext);
        RetrieveBlueprintModuleDataPluginPointVisitor retrieveBlueprintModuleData = new RetrieveBlueprintModuleDataPluginPointVisitor(blueprintParam);
        List optionList = safeAccessor.forType(BlueprintModuleDescriptor.class, (PluginPointFunction)retrieveBlueprintModuleData);
        Iterable dataIterator = Options.flatten((Iterable)optionList);
        return Lists.newArrayList((Iterable)dataIterator);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, RuleSetInput> generateRuleSetInput(ApplicationUser user, @Nonnull String moduleKey, @Nonnull ProjectContext projectContext) {
        BlueprintParamImpl blueprintParam = new BlueprintParamImpl(user, projectContext);
        SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
        io.atlassian.fugue.Either ruleSetInputResult = StepsConverters.newerEither((Either)safeAccessor.forKey(moduleKey, BlueprintModuleDescriptor.class, (PluginPointFunction)new GenerateRuleSetInputPluginPointVisitor(blueprintParam)));
        return this.convert(ruleSetInputResult);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, BlueprintDetails> getBlueprintDetails(@Nonnull ApplicationUser user, @Nonnull String moduleKey, @Nonnull ProjectContext projectContext) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"moduleKey", (Object)moduleKey);
        Assertions.notNull((String)"projectContext", (Object)projectContext);
        BlueprintParamImpl blueprintParam = new BlueprintParamImpl(user, projectContext);
        SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
        io.atlassian.fugue.Either blueprintDetailsResult = StepsConverters.newerEither((Either)safeAccessor.forKey(moduleKey, BlueprintModuleDescriptor.class, (PluginPointFunction)new BlueprintDetailsPluginPointVisitor(blueprintParam)));
        return this.convert(blueprintDetailsResult);
    }

    private io.atlassian.fugue.Option<String> renderHelpTemplate(String templateAddress) {
        String[] templateKeyAndName = templateAddress.split("/");
        if (templateKeyAndName.length != 2) {
            this.log.error("Blueprint help template address '{}' must be in the format module-key/template.name", (Object)templateAddress);
            return io.atlassian.fugue.Option.none(String.class);
        }
        try {
            HashMap emptyParams = Maps.newHashMap();
            return io.atlassian.fugue.Option.option((Object)this.soyRenderer.render(templateKeyAndName[0], templateKeyAndName[1], (Map)emptyParams));
        }
        catch (SoyException soyException) {
            this.log.error(soyException.getMessage());
            return io.atlassian.fugue.Option.none(String.class);
        }
    }

    private <T> io.atlassian.fugue.Either<AnError, T> convert(io.atlassian.fugue.Either<? extends ModuleAccessError, io.atlassian.fugue.Either<AnError, T>> result) {
        return (io.atlassian.fugue.Either)result.fold(left -> io.atlassian.fugue.Either.left((Object)this.toAnError((ModuleAccessError)left)), right -> right);
    }

    private AnError toAnError(ModuleAccessError moduleAccessError) {
        String errorMsgKey = moduleAccessError instanceof ModuleNotFoundError ? "sd.automation.module.access.error.module.unknown" : "sd.automation.module.access.error.module.invalid";
        return this.errorResultHelper.notFound404(errorMsgKey, new Object[0]).build();
    }

    private class BlueprintDetailsPluginPointVisitor
    extends BlueprintConditionPluginPointFunction<io.atlassian.fugue.Either<AnError, BlueprintDetails>> {
        public BlueprintDetailsPluginPointVisitor(Blueprint.BlueprintParam blueprintParam) {
            super(blueprintParam);
        }

        @Override
        protected io.atlassian.fugue.Either<AnError, BlueprintDetails> onModuleShouldDisplay(BlueprintModuleDescriptor moduleDescriptor, Blueprint module) {
            io.atlassian.fugue.Either ruleSetInputResult = StepsConverters.newerEither((Either)moduleDescriptor.getModule().generateRuleSetInput(this.blueprintParam));
            if (ruleSetInputResult.isLeft()) {
                return io.atlassian.fugue.Either.left((Object)ruleSetInputResult.left().get());
            }
            RuleSetInput ruleSetInput = (RuleSetInput)ruleSetInputResult.right().get();
            io.atlassian.fugue.Option helpTitleKey = StepsConverters.newerOption(moduleDescriptor.getHelpTitleKey());
            io.atlassian.fugue.Option helpDescriptionKey = StepsConverters.newerOption(moduleDescriptor.getHelpDescriptionKey());
            io.atlassian.fugue.Option helpTemplate = StepsConverters.newerOption(moduleDescriptor.getHelpTemplate());
            BlueprintHelpImpl blueprintHelp = new BlueprintHelpImpl(helpTitleKey.isDefined() ? BlueprintManagerImpl.this.i18nHelper.getText((String)helpTitleKey.get()) : BlueprintManagerImpl.this.i18nHelper.getText("sd.automation.blueprint.help.title.default"), helpDescriptionKey.isDefined() ? BlueprintManagerImpl.this.i18nHelper.getText((String)helpDescriptionKey.get()) : BlueprintManagerImpl.this.i18nHelper.getText("sd.automation.blueprint.help.description.default"), (Option<String>)StepsConverters.olderOption((io.atlassian.fugue.Option)(helpTemplate.isDefined() ? BlueprintManagerImpl.this.renderHelpTemplate((String)helpTemplate.get()) : BlueprintManagerImpl.this.renderHelpTemplate(BlueprintManagerImpl.DEFAULT_BLUEPRINT_HELP_FULL_ADDRESS))));
            BlueprintDetailsImpl blueprintDetails = new BlueprintDetailsImpl(ruleSetInput, blueprintHelp);
            return io.atlassian.fugue.Either.right((Object)blueprintDetails);
        }

        @Override
        protected io.atlassian.fugue.Either<AnError, BlueprintDetails> onModuleShouldNotDisplay(BlueprintModuleDescriptor moduleDescriptor, Blueprint module) {
            return StepsConverters.newerEither((Either)BlueprintManagerImpl.this.errorResultHelper.error(HttpStatusCode.NOT_FOUND, "sd.automation.module.access.error.module.unknown", new Object[0]));
        }
    }

    private abstract class BlueprintConditionPluginPointFunction<RT>
    extends ConditionAwarePluginPointFunction<BlueprintModuleDescriptor, Blueprint, RT> {
        protected Blueprint.BlueprintParam blueprintParam;

        public BlueprintConditionPluginPointFunction(Blueprint.BlueprintParam blueprintParam) {
            this.blueprintParam = blueprintParam;
        }

        @Override
        protected final Map<String, Object> getConditionContext() {
            HashMap contextMap = Maps.newHashMap();
            contextMap.put("user", this.blueprintParam.getUser());
            contextMap.put("projectContext", this.blueprintParam.getProjectContext());
            return contextMap;
        }
    }

    private class GenerateRuleSetInputPluginPointVisitor
    extends BlueprintConditionPluginPointFunction<io.atlassian.fugue.Either<AnError, RuleSetInput>> {
        public GenerateRuleSetInputPluginPointVisitor(Blueprint.BlueprintParam blueprintParam) {
            super(blueprintParam);
        }

        @Override
        protected io.atlassian.fugue.Either<AnError, RuleSetInput> onModuleShouldDisplay(BlueprintModuleDescriptor moduleDescriptor, Blueprint module) {
            return StepsConverters.newerEither((Either)moduleDescriptor.getModule().generateRuleSetInput(this.blueprintParam));
        }

        @Override
        protected io.atlassian.fugue.Either<AnError, RuleSetInput> onModuleShouldNotDisplay(BlueprintModuleDescriptor moduleDescriptor, Blueprint module) {
            return StepsConverters.newerEither((Either)BlueprintManagerImpl.this.errorResultHelper.error(HttpStatusCode.NOT_FOUND, "sd.automation.module.access.error.module.unknown", new Object[0]));
        }
    }

    private class RetrieveBlueprintModuleDataPluginPointVisitor
    extends BlueprintConditionPluginPointFunction<io.atlassian.fugue.Option<BlueprintModuleData>> {
        public RetrieveBlueprintModuleDataPluginPointVisitor(Blueprint.BlueprintParam blueprintParam) {
            super(blueprintParam);
        }

        @Override
        protected io.atlassian.fugue.Option<BlueprintModuleData> onModuleShouldDisplay(BlueprintModuleDescriptor moduleDescriptor, Blueprint module) {
            return io.atlassian.fugue.Option.some((Object)new BlueprintModuleData(moduleDescriptor.getCompleteKey(), moduleDescriptor.getName(), moduleDescriptor.getDescription(), (io.atlassian.fugue.Option<String>)StepsConverters.newerOption(moduleDescriptor.getIconPath()), moduleDescriptor.getWeight()));
        }

        @Override
        protected io.atlassian.fugue.Option<BlueprintModuleData> onModuleShouldNotDisplay(BlueprintModuleDescriptor moduleDescriptor, Blueprint module) {
            return io.atlassian.fugue.Option.none();
        }
    }
}

