/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.message.helper;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.result.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageCache;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.UserMessageHelper;
import com.atlassian.servicedesk.plugins.automation.internal.execution.message.helper.UserCache;
import com.atlassian.util.concurrent.Assertions;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class UserMessageHelperImpl
implements UserMessageHelper {
    private final UserManager userManager;

    @Autowired
    public UserMessageHelperImpl(@Nonnull UserManager userManager) {
        this.userManager = userManager;
    }

    public String getDataKey(String prefix) {
        Assertions.isTrue((String)"prefix cannot be blank", (boolean)StringUtils.isNotBlank((String)prefix));
        return prefix + "UserKey";
    }

    public Class<String> getDataValueType() {
        return String.class;
    }

    public boolean isDefined(RuleMessage ruleMessage, String prefix) {
        io.atlassian.fugue.Option userKey = StepsConverters.newerOption((Option)ruleMessage.getValue(this.getDataKey(prefix)));
        return userKey.isDefined();
    }

    public Either<AnError, ApplicationUser> getUser(RuleMessage ruleMessage, String prefix) {
        UserCache issueCache = this.getUserCache(ruleMessage, prefix);
        io.atlassian.fugue.Option<io.atlassian.fugue.Either<AnError, ApplicationUser>> userOpt = issueCache.getUserResult();
        if (userOpt.isDefined()) {
            return StepsConverters.olderEither((io.atlassian.fugue.Either)((io.atlassian.fugue.Either)userOpt.get()));
        }
        io.atlassian.fugue.Either<AnError, ApplicationUser> userEither = this.loadUser(ruleMessage, prefix);
        this.setUserCache(ruleMessage, prefix, issueCache.withUserResult(userEither));
        return StepsConverters.olderEither(userEither);
    }

    public void setUser(RuleMessage ruleMessage, String prefix, ApplicationUser user) {
        UserCache issueCache = this.getUserCache(ruleMessage, prefix);
        io.atlassian.fugue.Either userEither = io.atlassian.fugue.Either.right((Object)user);
        this.setUserCache(ruleMessage, prefix, issueCache.withUserResult((io.atlassian.fugue.Either<AnError, ApplicationUser>)userEither));
    }

    public void setUser(RuleMessageBuilder builder, String prefix, ApplicationUser user) {
        this.setUser(builder, prefix, user.getKey());
    }

    public void setUser(RuleMessageBuilder builder, String prefix, String userKey) {
        builder.putValue(this.getDataKey(prefix), userKey);
        RuleMessageCache cache = builder.getCache();
        cache.remove(this.getCacheKey(prefix));
    }

    private io.atlassian.fugue.Either<AnError, ApplicationUser> loadUser(RuleMessage ruleMessage, String prefix) {
        io.atlassian.fugue.Option userKeyOpt = StepsConverters.newerOption((Option)ruleMessage.getValue(this.getDataKey(prefix)));
        if (userKeyOpt.isDefined()) {
            String userKey = (String)userKeyOpt.get();
            try {
                ApplicationUser user = this.userManager.getUserByKey(userKey);
                if (user != null) {
                    return io.atlassian.fugue.Either.right((Object)user);
                }
                return StepsConverters.newerEither((Either)ServiceResult.error((int)HttpStatusCode.NOT_FOUND, (String)"User count not be found"));
            }
            catch (DataAccessException e) {
                return StepsConverters.newerEither((Either)ServiceResult.error((int)HttpStatusCode.NOT_FOUND, (String)e.getMessage()));
            }
        }
        return StepsConverters.newerEither((Either)ServiceResult.error((int)HttpStatusCode.NOT_FOUND, (String)"No value found for given prefix"));
    }

    private UserCache getUserCache(RuleMessage ruleMessage, String prefix) {
        Object o;
        RuleMessageCache cache = ruleMessage.getCache();
        io.atlassian.fugue.Option object = StepsConverters.newerOption((Option)cache.get(this.getCacheKey(prefix)));
        if (object.isDefined() && (o = object.get()) instanceof UserCache) {
            return (UserCache)o;
        }
        return new UserCache();
    }

    private void setUserCache(RuleMessage ruleMessage, String prefix, UserCache issueCache) {
        RuleMessageCache cache = ruleMessage.getCache();
        cache.set(this.getCacheKey(prefix), (Object)issueCache);
    }

    private String getCacheKey(String prefix) {
        return UserMessageHelperImpl.class.getName() + "_" + prefix;
    }
}

