/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.message.helper;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.result.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageCache;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.internal.execution.message.helper.IssueCache;
import com.atlassian.servicedesk.plugins.automation.internal.execution.message.helper.RuleMessageConversionHelper;
import com.atlassian.util.concurrent.Assertions;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
class IssueMessageHelperImpl
implements IssueMessageHelper {
    private static final Logger log = LoggerFactory.getLogger(IssueMessageHelperImpl.class);
    private final IssueManager issueManager;
    private final IssueIndexingService issueIndexingService;

    @Autowired
    public IssueMessageHelperImpl(@Nonnull IssueManager issueManager, IssueIndexingService issueIndexingService) {
        this.issueManager = issueManager;
        this.issueIndexingService = issueIndexingService;
    }

    public String getDataKeyForIssueKey(String prefix) {
        Assertions.isTrue((String)"prefix cannot be blank", (boolean)StringUtils.isNotBlank((String)prefix));
        return prefix + "Key";
    }

    public Class<String> getDataValueTypeForIssueKey() {
        return String.class;
    }

    public String getDataKeyForIssueId(String prefix) {
        Assertions.isTrue((String)"prefix cannot be blank", (boolean)StringUtils.isNotBlank((String)prefix));
        return prefix + "Id";
    }

    public Class<Long> getDataValueTypeForIssueId() {
        return Long.class;
    }

    public boolean issueIsDefined(RuleMessage ruleMessage) {
        return this.issueIsDefined(ruleMessage, "issue");
    }

    public boolean issueIsDefined(RuleMessage ruleMessage, String prefix) {
        io.atlassian.fugue.Option<Long> issueId = RuleMessageConversionHelper.getLongFromRuleMessage(ruleMessage, this.getDataKeyForIssueId(prefix));
        if (issueId.isDefined()) {
            return true;
        }
        io.atlassian.fugue.Option issueKey = StepsConverters.newerOption((Option)ruleMessage.getValue(this.getDataKeyForIssueKey(prefix)));
        return issueKey.isDefined();
    }

    public Either<AnError, Issue> getIssue(RuleMessage ruleMessage) {
        return this.getIssue(ruleMessage, "issue");
    }

    public void invalidateIssue(RuleMessage ruleMessage) {
        this.invalidateIssue(ruleMessage, "issue");
    }

    public void setIssue(RuleMessage ruleMessage, Issue issue) {
        this.setIssue(ruleMessage, issue, "issue");
    }

    public Option<Boolean> isReindexRequired(RuleMessage ruleMessage) {
        return this.isReindexRequired(ruleMessage, "issue");
    }

    public void setReindexRequired(RuleMessage ruleMessage, boolean reindexRequired) {
        this.setReindexRequired(ruleMessage, reindexRequired, "issue");
    }

    public void setIssueData(RuleMessageBuilder builder, Issue issue) {
        this.setIssueData(builder, issue, "issue");
    }

    public void setIssueData(RuleMessageBuilder builder, String issueKey) {
        this.setIssueData(builder, issueKey, "issue");
    }

    public void setIssueData(RuleMessageBuilder builder, long issueId) {
        this.setIssueData(builder, issueId, "issue");
    }

    public Either<AnError, Issue> getIssue(RuleMessage ruleMessage, String prefix) {
        Issue issue;
        IssueCache issueCache = this.getIssueCache(ruleMessage, prefix);
        io.atlassian.fugue.Option<Issue> issueOpt = issueCache.getIssueResult();
        if (issueOpt.isDefined()) {
            issue = (Issue)issueOpt.get();
        } else {
            io.atlassian.fugue.Either<AnError, Issue> issueEither = this.loadIssue(ruleMessage, prefix);
            if (issueEither.isLeft()) {
                return StepsConverters.olderEither(issueEither);
            }
            issue = (Issue)issueEither.right().get();
            this.setIssue(ruleMessage, issue, prefix);
            issueCache = this.getIssueCache(ruleMessage, prefix);
        }
        if (issueCache.isReindexRequired() && !issueCache.wasIndexed()) {
            try {
                this.issueIndexingService.reIndex(issue);
                this.setIssueCache(ruleMessage, prefix, issueCache.withIndexed());
            }
            catch (IndexException e) {
                log.warn("exception while indexing issue.", (Throwable)e);
            }
        }
        return StepsConverters.olderEither((io.atlassian.fugue.Either)io.atlassian.fugue.Either.right((Object)issue));
    }

    public void invalidateIssue(RuleMessage ruleMessage, String prefix) {
        IssueCache issueCache = this.getIssueCache(ruleMessage, prefix);
        this.setIssueCache(ruleMessage, prefix, issueCache.withoutIssueResult());
    }

    public void setIssue(RuleMessage ruleMessage, Issue issue, String prefix) {
        IssueCache issueCache = this.getIssueCache(ruleMessage, prefix);
        this.setIssueCache(ruleMessage, prefix, issueCache.withIssueResult(issue));
    }

    public Option<Boolean> isReindexRequired(RuleMessage ruleMessage, String prefix) {
        if (this.issueIsDefined(ruleMessage, prefix)) {
            IssueCache issueCache = this.getIssueCache(ruleMessage, prefix);
            return StepsConverters.olderOption((io.atlassian.fugue.Option)io.atlassian.fugue.Option.some((Object)issueCache.isReindexRequired()));
        }
        return StepsConverters.olderOption((io.atlassian.fugue.Option)io.atlassian.fugue.Option.none());
    }

    public void setReindexRequired(RuleMessage ruleMessage, boolean reindexRequired, String prefix) {
        IssueCache issueCache = this.getIssueCache(ruleMessage, prefix);
        this.setIssueCache(ruleMessage, prefix, issueCache.withReindexRequired(reindexRequired));
    }

    public void setIssueData(RuleMessageBuilder builder, Issue issue, String prefix) {
        builder.putValue(prefix + "Key", issue.getKey());
        builder.putValue(prefix + "Id", issue.getId().toString());
        Long projectId = issue.getProjectId();
        if (projectId != null) {
            builder.putValue("projectId", Long.toString(projectId));
        }
    }

    public void setIssueData(RuleMessageBuilder builder, String issueKey, String prefix) {
        builder.putValue(prefix + "Key", issueKey);
    }

    public void setIssueData(RuleMessageBuilder builder, long issueId, String prefix) {
        builder.putValue(prefix + "Id", String.valueOf(issueId));
    }

    private io.atlassian.fugue.Either<AnError, Issue> loadIssue(RuleMessage ruleMessage, String prefix) {
        io.atlassian.fugue.Option<Long> issueId = RuleMessageConversionHelper.getLongFromRuleMessage(ruleMessage, this.getDataKeyForIssueId(prefix));
        if (issueId.isDefined()) {
            try {
                MutableIssue issueObject = this.issueManager.getIssueObject((Long)issueId.get());
                if (issueObject != null) {
                    return io.atlassian.fugue.Either.right((Object)issueObject);
                }
                return StepsConverters.newerEither((Either)ServiceResult.error((int)HttpStatusCode.NOT_FOUND, (String)"Issue could not be found"));
            }
            catch (DataAccessException e) {
                return StepsConverters.newerEither((Either)ServiceResult.error((int)HttpStatusCode.NOT_FOUND, (String)e.getMessage()));
            }
        }
        io.atlassian.fugue.Option issueKey = StepsConverters.newerOption((Option)ruleMessage.getValue(this.getDataKeyForIssueKey(prefix)));
        if (issueKey.isDefined()) {
            try {
                MutableIssue issueObject = this.issueManager.getIssueObject((String)issueKey.get());
                if (issueObject != null) {
                    return io.atlassian.fugue.Either.right((Object)issueObject);
                }
                return StepsConverters.newerEither((Either)ServiceResult.error((int)HttpStatusCode.NOT_FOUND, (String)"Issue could not be found"));
            }
            catch (DataAccessException e) {
                return StepsConverters.newerEither((Either)ServiceResult.error((int)HttpStatusCode.NOT_FOUND, (String)e.getMessage()));
            }
        }
        return StepsConverters.newerEither((Either)ServiceResult.error((int)HttpStatusCode.NOT_FOUND, (String)"No value found for given prefix"));
    }

    private IssueCache getIssueCache(RuleMessage ruleMessage, String prefix) {
        Object o;
        RuleMessageCache cache = ruleMessage.getCache();
        io.atlassian.fugue.Option object = StepsConverters.newerOption((Option)cache.get(this.getCacheKey(prefix)));
        if (object.isDefined() && (o = object.get()) instanceof IssueCache) {
            return (IssueCache)o;
        }
        return new IssueCache();
    }

    private void setIssueCache(RuleMessage ruleMessage, String prefix, IssueCache issueCache) {
        RuleMessageCache cache = ruleMessage.getCache();
        cache.set(this.getCacheKey(prefix), (Object)issueCache);
    }

    private String getCacheKey(String prefix) {
        return IssueMessageHelperImpl.class.getName() + "_" + prefix;
    }
}

