/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.message.helper;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.EventTimeMessageHelper;
import com.atlassian.servicedesk.plugins.automation.internal.execution.message.helper.RuleMessageConversionHelper;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class EventTimeMessageHelperImpl
implements EventTimeMessageHelper {
    @VisibleForTesting
    protected static final String EVENT_TIME_MESSAGE_KEY = "eventTimeKey";

    private String generateKey(String prefix) {
        Assertions.isTrue((String)"prefix cannot be blank", (boolean)StringUtils.isNotBlank((String)prefix));
        return prefix + EVENT_TIME_MESSAGE_KEY;
    }

    public void setEventTime(RuleMessageBuilder builder, Date eventTime) {
        this.addEventTimeForKey(builder, eventTime, EVENT_TIME_MESSAGE_KEY);
    }

    public void setEventTime(RuleMessageBuilder builder, Date eventTime, String prefix) {
        String key = this.generateKey(prefix);
        this.addEventTimeForKey(builder, eventTime, key);
    }

    private void addEventTimeForKey(RuleMessageBuilder builder, Date eventTime, String key) {
        builder.putValue(key, String.valueOf(eventTime.getTime()));
    }

    public Option<Date> getEventTime(RuleMessage ruleMessage) {
        return this.getEventTimeForKey(ruleMessage, EVENT_TIME_MESSAGE_KEY);
    }

    public Option<Date> getEventTime(RuleMessage ruleMessage, String prefix) {
        String key = this.generateKey(prefix);
        return this.getEventTimeForKey(ruleMessage, key);
    }

    private Option<Date> getEventTimeForKey(RuleMessage ruleMessage, String key) {
        return StepsConverters.olderOption(RuleMessageConversionHelper.getLongFromRuleMessage(ruleMessage, key)).map(Date::new);
    }
}

