/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.message.helper;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.result.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageCache;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.CommentMessageHelper;
import com.atlassian.servicedesk.plugins.automation.internal.execution.message.helper.CommentCache;
import com.atlassian.servicedesk.plugins.automation.internal.execution.message.helper.RuleMessageConversionHelper;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class CommentMessageHelperImpl
implements CommentMessageHelper {
    private final CommentManager commentManager;

    @Autowired
    public CommentMessageHelperImpl(CommentManager commentManager) {
        this.commentManager = commentManager;
    }

    public String getDataKey(String prefix) {
        Assertions.isTrue((String)"prefix cannot be blank", (boolean)StringUtils.isNotBlank((String)prefix));
        return prefix + "commentId";
    }

    public Class<Long> getDataValueTypeForCommentId() {
        return Long.class;
    }

    public Either<AnError, Comment> getComment(RuleMessage ruleMessage) {
        return this.getComment(ruleMessage, "comment");
    }

    public Either<AnError, Comment> getComment(RuleMessage ruleMessage, String prefix) {
        CommentCache commentCache = this.getCommentCache(ruleMessage, prefix);
        io.atlassian.fugue.Option<io.atlassian.fugue.Either<AnError, Comment>> commentOpt = commentCache.getCommentResult();
        if (commentOpt.isDefined()) {
            return StepsConverters.olderEither((io.atlassian.fugue.Either)((io.atlassian.fugue.Either)commentOpt.get()));
        }
        io.atlassian.fugue.Either<AnError, Comment> commentResult = this.loadComment(ruleMessage, prefix);
        if (commentResult.isLeft()) {
            return StepsConverters.olderEither(commentResult);
        }
        this.setComment(ruleMessage, (Comment)commentResult.right().get(), prefix);
        return StepsConverters.olderEither(commentResult);
    }

    public Either<AnError, Boolean> getCommentEditedFlag(RuleMessage ruleMessage) {
        return (Either)ruleMessage.getValue("commenteditedflag").fold(() -> ServiceResult.error((int)HttpStatusCode.NOT_FOUND, (String)"Edited flag could not be found."), editedStr -> StepsConverters.olderEither((io.atlassian.fugue.Either)io.atlassian.fugue.Either.right((Object)this.stringToBoolean((String)editedStr))));
    }

    public void setComment(RuleMessage ruleMessage, Comment comment) {
        this.setComment(ruleMessage, comment, "comment");
    }

    public void setComment(RuleMessage ruleMessage, Comment comment, String prefix) {
        CommentCache commentCache = this.getCommentCache(ruleMessage, prefix);
        io.atlassian.fugue.Either commentEither = io.atlassian.fugue.Either.right((Object)comment);
        this.setCommentCache(ruleMessage, prefix, commentCache.withCommentResult((io.atlassian.fugue.Either<AnError, Comment>)commentEither));
    }

    public void setCommentData(RuleMessageBuilder builder, Comment comment) {
        this.setCommentData(builder, comment, "comment");
    }

    public void setCommentData(RuleMessageBuilder builder, Comment comment, String prefix) {
        builder.putValue(this.getDataKey("comment"), comment.getId().toString());
    }

    public void setCommentData(RuleMessageBuilder builder, Long commentId) {
        builder.putValue(this.getDataKey("comment"), commentId.toString());
    }

    public void setCommentEditedFlag(RuleMessageBuilder builder, boolean editedFlag) {
        builder.putValue("commenteditedflag", this.booleanToString(editedFlag));
    }

    public void setCommentData(RuleMessageBuilder builder, Long commentId, String prefix) {
        builder.putValue(this.getDataKey(prefix), commentId.toString());
    }

    private io.atlassian.fugue.Either<AnError, Comment> loadComment(RuleMessage ruleMessage, String prefix) {
        io.atlassian.fugue.Option<Long> commentId = RuleMessageConversionHelper.getLongFromRuleMessage(ruleMessage, this.getDataKey(prefix));
        if (commentId.isDefined()) {
            try {
                Comment comment = this.commentManager.getCommentById((Long)commentId.get());
                if (comment != null) {
                    return io.atlassian.fugue.Either.right((Object)comment);
                }
                return StepsConverters.newerEither((Either)ServiceResult.error((int)HttpStatusCode.NOT_FOUND, (String)"Comment could not be found"));
            }
            catch (DataAccessException e) {
                return StepsConverters.newerEither((Either)ServiceResult.error((int)HttpStatusCode.NOT_FOUND, (String)e.getMessage()));
            }
        }
        return StepsConverters.newerEither((Either)ServiceResult.error((int)HttpStatusCode.NOT_FOUND, (String)"No value found for given prefix"));
    }

    private CommentCache getCommentCache(RuleMessage ruleMessage, String prefix) {
        Object o;
        RuleMessageCache cache = ruleMessage.getCache();
        io.atlassian.fugue.Option object = StepsConverters.newerOption((Option)cache.get(this.getCacheKey(prefix)));
        if (object.isDefined() && (o = object.get()) instanceof CommentCache) {
            return (CommentCache)o;
        }
        return new CommentCache();
    }

    private void setCommentCache(RuleMessage ruleMessage, String prefix, CommentCache commentCache) {
        RuleMessageCache cache = ruleMessage.getCache();
        cache.set(this.getCacheKey(prefix), (Object)commentCache);
    }

    @VisibleForTesting
    String booleanToString(boolean bool) {
        return Objects.toString(bool);
    }

    @VisibleForTesting
    Boolean stringToBoolean(String string) {
        return Boolean.valueOf(string);
    }

    private String getCacheKey(String prefix) {
        return CommentMessageHelperImpl.class.getName() + "_" + prefix;
    }
}

