/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.message;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageCache;
import com.atlassian.servicedesk.plugins.automation.internal.execution.message.RuleMessageCacheImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.message.RuleMessageImpl;
import com.atlassian.util.concurrent.Assertions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class RuleMessageBuilderImpl
implements RuleMessageBuilder {
    @TenantAware(value=TenancyScope.TENANTED)
    private Map<String, String> data;
    private RuleMessageCache cache;

    public RuleMessageBuilderImpl() {
        this.data = new HashMap<String, String>();
        this.cache = new RuleMessageCacheImpl();
    }

    public RuleMessageBuilderImpl(@Nonnull RuleMessage ruleMessage) {
        Assertions.notNull((String)"ruleMessage", (Object)ruleMessage);
        this.data = new HashMap<String, String>(ruleMessage.getAllValues());
        this.cache = new RuleMessageCacheImpl(ruleMessage.getCache());
    }

    public RuleMessageBuilderImpl putValue(@Nonnull String key, @Nonnull String value) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)key));
        Assertions.notNull((String)"value", (Object)value);
        this.data.put(key, value);
        return this;
    }

    public RuleMessageBuilderImpl putAllValues(@Nonnull Map<String, String> data) {
        Assertions.notNull((String)"data", data);
        for (Map.Entry<String, String> entry : data.entrySet()) {
            this.putValue(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public RuleMessageCache getCache() {
        return this.cache;
    }

    public RuleMessage build() {
        return new RuleMessageImpl(this.data, this.cache);
    }
}

