/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.log;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Then;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ThenActionConfiguration;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ComponentConfigurationImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenActionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.log.AuditLogExecutionStatus;
import com.atlassian.servicedesk.plugins.automation.internal.execution.log.RuleSetAuditLogComponentDetailData;
import com.atlassian.servicedesk.plugins.automation.internal.module.ThenActionData;
import com.atlassian.servicedesk.plugins.automation.internal.module.ThenActionDisplayData;
import com.atlassian.servicedesk.plugins.automation.internal.module.ThenActionManager;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ThenAuditLogManager {
    private final ThenActionManager thenActionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public ThenAuditLogManager(ThenActionManager thenActionManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.thenActionManager = thenActionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    List<RuleSetAuditLogComponentDetailData> getThenActionData(Then then, Option<ThenExecution> thenExecutionOption) {
        return (List)thenExecutionOption.fold(() -> this.getThenSkipDetailData(then), thenExecution -> this.getThenExecutionDetailData(then, (ThenExecution)thenExecution));
    }

    private List<RuleSetAuditLogComponentDetailData> getThenSkipDetailData(Then then) {
        return then.getThenActionConfigurations().stream().map(config -> this.mapThenConfigToDisplayString((ThenActionConfiguration)config, (Option<ThenActionExecution>)Option.none())).collect(Collectors.toList());
    }

    private List<RuleSetAuditLogComponentDetailData> getThenExecutionDetailData(Then then, ThenExecution thenExecution) {
        return then.getThenActionConfigurations().stream().map(thenActionConfiguration -> {
            Option<ThenActionExecution> execution = this.getExecutionForId(thenExecution, ((ComponentConfigurationImpl)thenActionConfiguration).getId());
            return this.mapThenConfigToDisplayString((ThenActionConfiguration)thenActionConfiguration, execution);
        }).collect(Collectors.toList());
    }

    private Option<ThenActionExecution> getExecutionForId(ThenExecution thenActionExecution, long thenActionId) {
        return Option.fromOptional(thenActionExecution.getThenActionExecutions().stream().filter(execution -> execution.getThenActionId() == thenActionId).findAny());
    }

    private RuleSetAuditLogComponentDetailData mapThenConfigToDisplayString(ThenActionConfiguration config, Option<ThenActionExecution> executionOption) {
        Pair<Boolean, String> displayData = this.getDisplayData(config);
        AuditLogExecutionStatus status = this.getStatus(executionOption);
        Option outcomeMessage = executionOption.flatMap(execution -> execution.getResult().getMessage());
        return new RuleSetAuditLogComponentDetailData((Boolean)displayData.left(), status, (String)displayData.right(), (Option<String>)outcomeMessage);
    }

    private Pair<Boolean, String> getDisplayData(ThenActionConfiguration config) {
        return (Pair)this.thenActionManager.getConfiguredThenActionData(this.getLoggedInUser(), config.getModuleKey(), config.getData()).fold(error -> new Pair((Object)Boolean.TRUE, (Object)error.getErrorMessage()), data -> new Pair((Object)Boolean.FALSE, (Object)this.getThenActionDisplayString((ThenActionData)data)));
    }

    private String getThenActionDisplayString(ThenActionData thenActionData) {
        ThenActionDisplayData displayData = thenActionData.getThenActionDisplayData();
        return (String)displayData.getLabel().fold(displayData::getName, label -> displayData.getName() + ": " + label);
    }

    private AuditLogExecutionStatus getStatus(Option<ThenActionExecution> executionOption) {
        return (AuditLogExecutionStatus)((Object)executionOption.fold(() -> AuditLogExecutionStatus.NOT_EXECUTED, execution -> AuditLogExecutionStatus.fromThenActionOutcome((ThenActionExecution.Outcome)((Object)((Object)execution.getResult().getOutcome())))));
    }

    private ApplicationUser getLoggedInUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }
}

