/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.log;

import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfThen;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.IfThenImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl.RuleSetAuditDao;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.dao.ExecutionHistoryDao;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.RuleExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.log.IfAuditLogManager;
import com.atlassian.servicedesk.plugins.automation.internal.execution.log.RuleSetAuditLogComponentDetailData;
import com.atlassian.servicedesk.plugins.automation.internal.execution.log.RuleSetAuditLogData;
import com.atlassian.servicedesk.plugins.automation.internal.execution.log.RuleSetAuditLogIfThenData;
import com.atlassian.servicedesk.plugins.automation.internal.execution.log.ThenAuditLogManager;
import com.atlassian.servicedesk.plugins.automation.internal.execution.log.WhenAuditLogManager;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleSetAuditLogManager {
    private final RuleSetAuditDao ruleSetAuditDao;
    private final ExecutionHistoryDao executionHistoryDao;
    private final IfAuditLogManager ifAuditLogManager;
    private final ThenAuditLogManager thenAuditLogManager;
    private final WhenAuditLogManager whenHandlerAuditLogManager;

    @Autowired
    public RuleSetAuditLogManager(RuleSetAuditDao ruleSetAuditDao, ExecutionHistoryDao executionHistoryDao, IfAuditLogManager ifAuditLogManager, ThenAuditLogManager thenAuditLogManager, WhenAuditLogManager whenHandlerAuditLogManager) {
        this.ruleSetAuditDao = ruleSetAuditDao;
        this.executionHistoryDao = executionHistoryDao;
        this.ifAuditLogManager = ifAuditLogManager;
        this.thenAuditLogManager = thenAuditLogManager;
        this.whenHandlerAuditLogManager = whenHandlerAuditLogManager;
    }

    public Option<RuleSetAuditLogData> getAuditLogForExecution(long executionHistoryId) {
        return this.executionHistoryDao.get(executionHistoryId).flatMap(this::getAuditLogWithExecution);
    }

    private Option<RuleSetAuditLogData> getAuditLogWithExecution(RuleExecution execution) {
        return this.ruleSetAuditDao.getRuleForId(execution.getRuleId()).map(rule -> this.getAuditLog(execution, (Rule)rule));
    }

    private RuleSetAuditLogData getAuditLog(RuleExecution execution, Rule rule) {
        List<RuleSetAuditLogComponentDetailData> whenData = this.getRuleSetAuditLogWhenData(rule);
        List<RuleSetAuditLogIfThenData> ifThenData = this.getRuleSetAuditLogIfThenData(execution, rule);
        return new RuleSetAuditLogData(execution.getResult().getMessage(), whenData, ifThenData);
    }

    private List<RuleSetAuditLogComponentDetailData> getRuleSetAuditLogWhenData(Rule rule) {
        return this.whenHandlerAuditLogManager.getWhenHandlerData(rule.getWhen());
    }

    private List<RuleSetAuditLogIfThenData> getRuleSetAuditLogIfThenData(RuleExecution execution, Rule rule) {
        return rule.getIfThens().stream().map(ifthen -> this.mapIfThenData(execution, (IfThen)ifthen)).collect(Collectors.toList());
    }

    private RuleSetAuditLogIfThenData mapIfThenData(RuleExecution execution, IfThen ifthen) {
        Option<IfThenExecution> ifthenExecution = this.getExecutionForIfThen(execution, ifthen);
        List<RuleSetAuditLogComponentDetailData> ifData = this.mapIfData(ifthen, ifthenExecution);
        List<RuleSetAuditLogComponentDetailData> thenData = this.mapThenData(ifthen, ifthenExecution);
        return new RuleSetAuditLogIfThenData(ifData, thenData);
    }

    private List<RuleSetAuditLogComponentDetailData> mapIfData(IfThen ifthen, Option<IfThenExecution> ifthenExecution) {
        Option ifExecution = ifthenExecution.flatMap(IfThenExecution::getIfExecution);
        return this.ifAuditLogManager.getIfConditionData(ifthen.getIf(), (Option<IfExecution>)ifExecution);
    }

    private List<RuleSetAuditLogComponentDetailData> mapThenData(IfThen ifthen, Option<IfThenExecution> ifthenExecution) {
        Option thenExecution = ifthenExecution.flatMap(IfThenExecution::getThenExecution);
        return this.thenAuditLogManager.getThenActionData(ifthen.getThen(), (Option<ThenExecution>)thenExecution);
    }

    private Option<IfThenExecution> getExecutionForIfThen(RuleExecution execution, IfThen ifthen) {
        return Option.fromOptional(execution.getIfThenExecutions().stream().filter(ifthenExecution -> ((IfThenImpl)ifthen).getId() == ifthenExecution.getIfThenId()).findAny());
    }
}

