/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.history.dao.querydsl;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.QThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewThenActionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.dao.querydsl.ThenActionExecutionDao;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenActionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenExecutionImpl;
import com.atlassian.util.concurrent.Assertions;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.util.List;

final class ThenExecutionDao
extends QueryDslDao {
    private final ThenActionExecutionDao thenActionExecutionDao;

    ThenExecutionDao(DatabaseAccessor databaseAccessor, QueryDslDaoHelper helper) {
        super(databaseAccessor, helper);
        this.thenActionExecutionDao = new ThenActionExecutionDao(databaseAccessor, helper);
    }

    long deleteExecutionHistoryEntries(DatabaseConnection connection, long referenceEpoch) {
        return this.thenActionExecutionDao.deleteThenActionExecutionHistoryEntries(connection, referenceEpoch) + this.deleteThenExecutionHistoryEntries(connection, referenceEpoch);
    }

    private long deleteThenExecutionHistoryEntries(DatabaseConnection connection, long referenceEpoch) {
        return connection.delete((RelationalPath)Tables.THEN_EXECUTION).where((Predicate)Tables.THEN_EXECUTION.IF_THEN_EXECUTION_ID.in((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(Tables.IF_THEN_EXECUTION.ID).from((Expression)Tables.IF_THEN_EXECUTION)).innerJoin((EntityPath)Tables.RULE_EXECUTION)).on((Predicate)Tables.IF_THEN_EXECUTION.RULE_EXECUTION_ID.eq(Tables.RULE_EXECUTION.ID))).where((Predicate)Tables.RULE_EXECUTION.FINISH_TIME_MILLIS.lt((Number)referenceEpoch)))).execute();
    }

    void create(NewThenExecution toInsert, long associatedIfThenExecutionId, DatabaseConnection connection) {
        Assertions.notNull((String)"toInsert", (Object)toInsert);
        Assertions.notNull((String)"connection", (Object)connection);
        this.insertThenExecution(toInsert, associatedIfThenExecutionId, connection);
    }

    private void insertThenExecution(NewThenExecution toInsert, long associatedIfThenExecutionId, DatabaseConnection connection) {
        SQLInsertClause insertStatement = connection.insert((RelationalPath)Tables.THEN_EXECUTION).set(Tables.THEN_EXECUTION.START_TIME_MILLIS, (Object)toInsert.getStartTime().getMillis()).set(Tables.THEN_EXECUTION.FINISH_TIME_MILLIS, (Object)toInsert.getFinishTime().getMillis()).set((Path)Tables.THEN_EXECUTION.OUTCOME, (Object)((ThenExecution.Outcome)((Object)toInsert.getResult().getOutcome())).name()).set((Path)Tables.THEN_EXECUTION.MESSAGE, toInsert.getResult().getMessage().getOrNull()).set(Tables.THEN_EXECUTION.IF_THEN_EXECUTION_ID, (Object)associatedIfThenExecutionId);
        long insertedThenExecutionId = this.helper.executeSingleRowInsertReturningId(connection, insertStatement, "Failed to insert new row into " + Tables.THEN_EXECUTION.getTableName());
        this.insertThenActionExecutions(toInsert.getThenActionExecutions(), insertedThenExecutionId, connection);
    }

    private void insertThenActionExecutions(List<NewThenActionExecution> executionsToInsert, long associatedThenExecutionId, DatabaseConnection connection) {
        for (NewThenActionExecution toInsert : executionsToInsert) {
            this.thenActionExecutionDao.create(toInsert, associatedThenExecutionId, connection);
        }
    }

    Option<ThenExecution> getForIfThenExecutionWithId(long ifThenExecutionId, Option<String> executedBy, DatabaseConnection connection) {
        Option<QThenExecution.Row> ruleExecutionRowOpt = this.helper.getSingleResultForColumnIdMatch((RelationalPathBase<?>)Tables.THEN_EXECUTION, Tables.THEN_EXECUTION.IF_THEN_EXECUTION_ID, ifThenExecutionId, QThenExecution.Row.class, connection);
        if (ruleExecutionRowOpt.isEmpty()) {
            return Option.none();
        }
        ThenExecution loadedThenExecution = this.loadThenExecutionFromDbRow((QThenExecution.Row)ruleExecutionRowOpt.get(), executedBy, connection);
        return Option.some((Object)loadedThenExecution);
    }

    private ThenExecution loadThenExecutionFromDbRow(QThenExecution.Row dbRow, Option<String> executedBy, DatabaseConnection connection) {
        List<ThenActionExecution> associatedThenConditionExecutions = this.thenActionExecutionDao.getForThenExecutionWithId(dbRow.id, executedBy, connection);
        return new ThenExecutionImpl(dbRow.id, associatedThenConditionExecutions, QueryDslDaoHelper.convertLongToDateTime(dbRow.startTimeMillis), QueryDslDaoHelper.convertLongToDateTime(dbRow.finishTimeMillis), executedBy, QueryDslDaoHelper.constructExecutionResult(dbRow.outcome, ThenExecution.Outcome.class, dbRow.message));
    }
}

