/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.history.dao.querydsl;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.QIfThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.dao.querydsl.IfExecutionDao;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.dao.querydsl.ThenExecutionDao;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfThenExecutionImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenExecution;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.util.List;

final class IfThenExecutionDao
extends QueryDslDao {
    private final IfExecutionDao ifExecutionDao;
    private final ThenExecutionDao thenExecutionDao;

    IfThenExecutionDao(DatabaseAccessor databaseAccessor, QueryDslDaoHelper helper) {
        super(databaseAccessor, helper);
        this.ifExecutionDao = new IfExecutionDao(databaseAccessor, helper);
        this.thenExecutionDao = new ThenExecutionDao(databaseAccessor, helper);
    }

    long deleteExecutionHistoryEntries(DatabaseConnection connection, long referenceEpoch) {
        return this.ifExecutionDao.deleteExecutionHistoryEntries(connection, referenceEpoch) + this.thenExecutionDao.deleteExecutionHistoryEntries(connection, referenceEpoch) + this.deleteIfThenExecutionHistoryEntries(connection, referenceEpoch);
    }

    private long deleteIfThenExecutionHistoryEntries(DatabaseConnection connection, long referenceEpoch) {
        return connection.delete((RelationalPath)Tables.IF_THEN_EXECUTION).where((Predicate)Tables.IF_THEN_EXECUTION.RULE_EXECUTION_ID.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(Tables.RULE_EXECUTION.ID).from((Expression)Tables.RULE_EXECUTION)).where((Predicate)Tables.RULE_EXECUTION.FINISH_TIME_MILLIS.lt((Number)referenceEpoch)))).execute();
    }

    void create(NewIfThenExecution toInsert, long associatedRuleExecutionId, DatabaseConnection connection) {
        Assertions.notNull((String)"toInsert", (Object)toInsert);
        Assertions.notNull((String)"connection", (Object)connection);
        this.insertIfThenExecution(toInsert, associatedRuleExecutionId, connection);
    }

    private void insertIfThenExecution(NewIfThenExecution toInsert, long associatedRuleExecutionId, DatabaseConnection connection) {
        SQLInsertClause insertStatement = connection.insert((RelationalPath)Tables.IF_THEN_EXECUTION).set(Tables.IF_THEN_EXECUTION.START_TIME_MILLIS, (Object)toInsert.getStartTime().getMillis()).set(Tables.IF_THEN_EXECUTION.FINISH_TIME_MILLIS, (Object)toInsert.getFinishTime().getMillis()).set((Path)Tables.IF_THEN_EXECUTION.OUTCOME, (Object)((IfThenExecution.Outcome)((Object)toInsert.getResult().getOutcome())).name()).set((Path)Tables.IF_THEN_EXECUTION.MESSAGE, toInsert.getResult().getMessage().getOrNull()).set(Tables.IF_THEN_EXECUTION.RULE_EXECUTION_ID, (Object)associatedRuleExecutionId).set(Tables.IF_THEN_EXECUTION.IF_THEN_ID, (Object)toInsert.getIfThenId());
        long insertedIfThenExecutionId = this.helper.executeSingleRowInsertReturningId(connection, insertStatement, "Failed to insert new row into " + Tables.IF_THEN_EXECUTION.getTableName());
        this.insertIfExecution(toInsert.getIfExecution(), insertedIfThenExecutionId, connection);
        this.insertThenExecution(toInsert.getThenExecution(), insertedIfThenExecutionId, connection);
    }

    private void insertIfExecution(Option<NewIfExecution> toInsertIfExecution, long associatedIfThenExecutionId, DatabaseConnection connection) {
        this.ifExecutionDao.create((NewIfExecution)toInsertIfExecution.get(), associatedIfThenExecutionId, connection);
    }

    private void insertThenExecution(Option<NewThenExecution> toInsertThenExecution, long associatedIfThenExecutionId, DatabaseConnection connection) {
        if (toInsertThenExecution.isEmpty()) {
            return;
        }
        this.thenExecutionDao.create((NewThenExecution)toInsertThenExecution.get(), associatedIfThenExecutionId, connection);
    }

    List<IfThenExecution> getAllForRuleExecutionWithId(long ruleExecutionId, Option<String> executedBy, DatabaseConnection connection) {
        List<QIfThenExecution.Row> ruleExecutionRows = this.helper.getMultipleOrderedResultsForColumnIdMatch((RelationalPathBase<?>)Tables.IF_THEN_EXECUTION, Tables.IF_THEN_EXECUTION.RULE_EXECUTION_ID, ruleExecutionId, QIfThenExecution.Row.class, connection, (OrderSpecifier<?>)Tables.IF_THEN_EXECUTION.ID.asc());
        if (ruleExecutionRows.isEmpty()) {
            return ImmutableList.of();
        }
        return this.loadIfThenExecutionsFromDbRows(ruleExecutionRows, executedBy, connection);
    }

    private List<IfThenExecution> loadIfThenExecutionsFromDbRows(List<QIfThenExecution.Row> dbRows, Option<String> executedBy, DatabaseConnection connection) {
        ImmutableList.Builder loadedIfThenExecs = ImmutableList.builder();
        for (QIfThenExecution.Row ruleRow : dbRows) {
            loadedIfThenExecs.add((Object)this.loadIfThenExecutionFromDbRow(ruleRow, executedBy, connection));
        }
        return loadedIfThenExecs.build();
    }

    private IfThenExecution loadIfThenExecutionFromDbRow(QIfThenExecution.Row dbRow, Option<String> executedBy, DatabaseConnection connection) {
        Option<IfExecution> associatedIfExecution = this.ifExecutionDao.getForIfThenExecutionWithId(dbRow.id, executedBy, connection);
        Option<ThenExecution> associatedThenExecution = this.thenExecutionDao.getForIfThenExecutionWithId(dbRow.id, executedBy, connection);
        return new IfThenExecutionImpl(dbRow.id, dbRow.ifThenId, associatedIfExecution, associatedThenExecution, QueryDslDaoHelper.convertLongToDateTime(dbRow.startTimeMillis), QueryDslDaoHelper.convertLongToDateTime(dbRow.finishTimeMillis), executedBy, QueryDslDaoHelper.constructExecutionResult(dbRow.outcome, IfThenExecution.Outcome.class, dbRow.message));
    }
}

