/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.history.dao.querydsl;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.QIfExecution;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfConditionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.dao.querydsl.IfConditionExecutionDao;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfConditionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfExecutionImpl;
import com.atlassian.util.concurrent.Assertions;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.util.List;

final class IfExecutionDao
extends QueryDslDao {
    private final IfConditionExecutionDao ifConditionExecutionDao;

    IfExecutionDao(DatabaseAccessor databaseAccessor, QueryDslDaoHelper helper) {
        super(databaseAccessor, helper);
        this.ifConditionExecutionDao = new IfConditionExecutionDao(databaseAccessor, helper);
    }

    long deleteExecutionHistoryEntries(DatabaseConnection connection, long referenceEpoch) {
        return this.ifConditionExecutionDao.deleteIfConditionExecutionHistoryEntries(connection, referenceEpoch) + this.deleteIfExecutionHistoryEntries(connection, referenceEpoch);
    }

    private long deleteIfExecutionHistoryEntries(DatabaseConnection connection, long referenceEpoch) {
        return connection.delete((RelationalPath)Tables.IF_EXECUTION).where((Predicate)Tables.IF_EXECUTION.IF_THEN_EXECUTION_ID.in((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(Tables.IF_THEN_EXECUTION.ID).from((Expression)Tables.IF_THEN_EXECUTION)).innerJoin((EntityPath)Tables.RULE_EXECUTION)).on((Predicate)Tables.IF_THEN_EXECUTION.RULE_EXECUTION_ID.eq(Tables.RULE_EXECUTION.ID))).where((Predicate)Tables.RULE_EXECUTION.FINISH_TIME_MILLIS.lt((Number)referenceEpoch)))).execute();
    }

    void create(NewIfExecution toInsert, long associatedIfThenExecutionId, DatabaseConnection connection) {
        Assertions.notNull((String)"toInsert", (Object)toInsert);
        Assertions.notNull((String)"connection", (Object)connection);
        this.insertIfExecution(toInsert, associatedIfThenExecutionId, connection);
    }

    private void insertIfExecution(NewIfExecution toInsert, long associatedIfThenExecutionId, DatabaseConnection connection) {
        SQLInsertClause insertStatement = connection.insert((RelationalPath)Tables.IF_EXECUTION).set(Tables.IF_EXECUTION.START_TIME_MILLIS, (Object)toInsert.getStartTime().getMillis()).set(Tables.IF_EXECUTION.FINISH_TIME_MILLIS, (Object)toInsert.getFinishTime().getMillis()).set((Path)Tables.IF_EXECUTION.OUTCOME, (Object)((IfExecution.Outcome)((Object)toInsert.getResult().getOutcome())).name()).set((Path)Tables.IF_EXECUTION.MESSAGE, toInsert.getResult().getMessage().getOrNull()).set(Tables.IF_EXECUTION.IF_THEN_EXECUTION_ID, (Object)associatedIfThenExecutionId);
        long insertedIfExecutionId = this.helper.executeSingleRowInsertReturningId(connection, insertStatement, "Failed to insert new row into " + Tables.IF_EXECUTION.getTableName());
        this.insertIfConditionExecutions(toInsert.getIfConditionExecutions(), insertedIfExecutionId, connection);
    }

    private void insertIfConditionExecutions(List<NewIfConditionExecution> executionsToInsert, long associatedIfExecutionId, DatabaseConnection connection) {
        for (NewIfConditionExecution toInsert : executionsToInsert) {
            this.ifConditionExecutionDao.create(toInsert, associatedIfExecutionId, connection);
        }
    }

    public Option<IfExecution> getForIfThenExecutionWithId(long ifThenExecutionId, Option<String> executedBy, DatabaseConnection connection) {
        Option<QIfExecution.Row> ruleExecutionRowOpt = this.helper.getSingleResultForColumnIdMatch((RelationalPathBase<?>)Tables.IF_EXECUTION, Tables.IF_EXECUTION.IF_THEN_EXECUTION_ID, ifThenExecutionId, QIfExecution.Row.class, connection);
        if (ruleExecutionRowOpt.isEmpty()) {
            return Option.none();
        }
        IfExecution loadedIfExecution = this.loadIfExecutionFromDbRow((QIfExecution.Row)ruleExecutionRowOpt.get(), executedBy, connection);
        return Option.some((Object)loadedIfExecution);
    }

    private IfExecution loadIfExecutionFromDbRow(QIfExecution.Row dbRow, Option<String> executedBy, DatabaseConnection connection) {
        List<IfConditionExecution> associatedIfConditionExecutions = this.ifConditionExecutionDao.getForIfConditionWithId(dbRow.id, executedBy, connection);
        return new IfExecutionImpl(dbRow.id, associatedIfConditionExecutions, QueryDslDaoHelper.convertLongToDateTime(dbRow.startTimeMillis), QueryDslDaoHelper.convertLongToDateTime(dbRow.finishTimeMillis), executedBy, QueryDslDaoHelper.constructExecutionResult(dbRow.outcome, IfExecution.Outcome.class, dbRow.message));
    }
}

