/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder;

import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewThenActionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewThenExecutionImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.ExecutionResultBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewIfThenExecutionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewThenActionExecutionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenExecution;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public final class NewThenExecutionBuilder {
    private final NewIfThenExecutionBuilder parent;
    private List<NewThenActionExecutionBuilder> thenActionExecutionBuilders;
    private DateTime startTime;
    private DateTime finishTime;
    private Option<String> executedBy;
    private ExecutionResultBuilder<ThenExecution.Outcome, NewThenExecutionBuilder> executionResultBuilder;

    public static NewThenExecutionBuilder newBuilder() {
        return new NewThenExecutionBuilder();
    }

    private NewThenExecutionBuilder() {
        this.parent = null;
        this.thenActionExecutionBuilders = Lists.newArrayList();
        this.executionResultBuilder = new ExecutionResultBuilder(this);
    }

    NewThenExecutionBuilder(NewIfThenExecutionBuilder parent) {
        this.parent = parent;
        this.thenActionExecutionBuilders = Lists.newArrayList();
        this.executionResultBuilder = new ExecutionResultBuilder(this);
    }

    NewThenExecutionBuilder(NewIfThenExecutionBuilder parent, NewThenExecution newThenExecution) {
        this.parent = parent;
        this.executionResultBuilder = new ExecutionResultBuilder(this, newThenExecution.getResult());
        this.startTime = newThenExecution.getStartTime();
        this.finishTime = newThenExecution.getFinishTime();
        this.executedBy = newThenExecution.getExecutedBy();
        this.thenActionExecutionBuilders = Lists.newArrayList();
        for (NewThenActionExecution thenActionExecution : newThenExecution.getThenActionExecutions()) {
            this.thenActionExecutionBuilders.add(new NewThenActionExecutionBuilder(this, thenActionExecution));
        }
    }

    public NewThenActionExecutionBuilder thenActionExecution() {
        NewThenActionExecutionBuilder thenActionExecutionBuilder = new NewThenActionExecutionBuilder(this);
        this.thenActionExecutionBuilders.add(thenActionExecutionBuilder);
        return thenActionExecutionBuilder;
    }

    public NewThenExecutionBuilder addThenActionExecution(NewThenActionExecution newThenActionExecution) {
        NewThenActionExecutionBuilder ifCondExecutionBuilder = new NewThenActionExecutionBuilder(this, newThenActionExecution);
        this.thenActionExecutionBuilders.add(ifCondExecutionBuilder);
        return this;
    }

    public NewThenExecutionBuilder startTime(DateTime theStartTime) {
        this.startTime = theStartTime;
        return this;
    }

    public NewThenExecutionBuilder finishTime(DateTime theFinishTime) {
        this.finishTime = theFinishTime;
        return this;
    }

    public NewThenExecutionBuilder executedBy(Option<String> theUserThatExecuted) {
        this.executedBy = theUserThatExecuted;
        return this;
    }

    public ExecutionResultBuilder<ThenExecution.Outcome, NewThenExecutionBuilder> executionResult() {
        return this.executionResultBuilder;
    }

    public NewIfThenExecutionBuilder endThenExecution() {
        return this.parent;
    }

    public NewThenExecution build() {
        this.validate();
        ArrayList thenActionExecutions = Lists.newArrayList();
        for (NewThenActionExecutionBuilder thenActionExecutionBuilder : this.thenActionExecutionBuilders) {
            thenActionExecutions.add(thenActionExecutionBuilder.build());
        }
        return new NewThenExecutionImpl(thenActionExecutions, this.startTime, this.finishTime, this.executedBy, this.executionResultBuilder.build());
    }

    private void validate() {
        Assertions.notNull((String)"startTime", (Object)this.startTime);
        Assertions.notNull((String)"finishTime", (Object)this.finishTime);
        Assertions.notNull((String)"executedBy", this.executedBy);
        Assertions.notNull((String)"executionResultBuilder", this.executionResultBuilder);
    }
}

