/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder;

import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewRuleExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewRuleExecutionImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.ExecutionResultBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewIfThenExecutionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.RuleExecution;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.joda.time.DateTime;

public final class NewRuleExecutionBuilder {
    private Long ruleId;
    private List<NewIfThenExecutionBuilder> ifThenExecutionBuilders = Lists.newArrayList();
    private Option<RuleMessage> ruleMessage = Option.none();
    private DateTime startTime;
    private DateTime finishTime;
    private Option<String> executedBy = Option.none();
    private ExecutionResultBuilder<RuleExecution.Outcome, NewRuleExecutionBuilder> executionResultBuilder = new ExecutionResultBuilder(this);

    public static NewRuleExecutionBuilder newBuilder() {
        return new NewRuleExecutionBuilder();
    }

    private NewRuleExecutionBuilder() {
    }

    public NewRuleExecutionBuilder ruleId(long theRuleId) {
        this.ruleId = theRuleId;
        return this;
    }

    public NewRuleExecutionBuilder ruleMessage(RuleMessage theRuleMessage) {
        this.ruleMessage = Option.some((Object)theRuleMessage);
        return this;
    }

    public NewRuleExecutionBuilder addIfThenExecution(NewIfThenExecution newIfThenExecution) {
        NewIfThenExecutionBuilder ifThenExecutionBuilder = new NewIfThenExecutionBuilder(this, newIfThenExecution);
        this.ifThenExecutionBuilders.add(ifThenExecutionBuilder);
        return this;
    }

    public NewIfThenExecutionBuilder ifThenExecution() {
        NewIfThenExecutionBuilder ifThenExecutionBuilder = new NewIfThenExecutionBuilder(this);
        this.ifThenExecutionBuilders.add(ifThenExecutionBuilder);
        return ifThenExecutionBuilder;
    }

    public NewRuleExecutionBuilder startTime(DateTime theStartTime) {
        this.startTime = theStartTime;
        return this;
    }

    public NewRuleExecutionBuilder finishTime(DateTime theFinishTime) {
        this.finishTime = theFinishTime;
        return this;
    }

    public NewRuleExecutionBuilder executedBy(String theUserThatExecuted) {
        this.executedBy = Option.some((Object)theUserThatExecuted);
        return this;
    }

    public ExecutionResultBuilder<RuleExecution.Outcome, NewRuleExecutionBuilder> executionResult() {
        return this.executionResultBuilder;
    }

    public NewRuleExecution build() {
        this.validate();
        ArrayList ifThenExecutions = Lists.newArrayList();
        for (NewIfThenExecutionBuilder ifThenExecutionBuilder : this.ifThenExecutionBuilders) {
            ifThenExecutions.add(ifThenExecutionBuilder.build());
        }
        return new NewRuleExecutionImpl(this.ruleId, (List<NewIfThenExecution>)ImmutableList.copyOf((Collection)ifThenExecutions), this.ruleMessage, this.startTime, this.finishTime, this.executedBy, this.executionResultBuilder.build());
    }

    private void validate() {
        Assertions.notNull((String)"ruleId", (Object)this.ruleId);
        Assertions.notNull((String)"startTime", (Object)this.startTime);
        Assertions.notNull((String)"finishTime", (Object)this.finishTime);
        Assertions.notNull((String)"executedBy", this.executedBy);
    }
}

