/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.history;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.dao.ExecutionHistoryDao;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class ExecutionHistoryCleanerJobRunner
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(ExecutionHistoryCleanerJobRunner.class);
    private final ExecutionHistoryDao executionHistoryDao;

    @Autowired
    ExecutionHistoryCleanerJobRunner(ExecutionHistoryDao executionHistoryDao) {
        this.executionHistoryDao = executionHistoryDao;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        this.cleanHistory();
        return JobRunnerResponse.success();
    }

    public long cleanHistory() {
        log.debug("Starting clean up of execution history entries");
        long deletedEntries = this.executionHistoryDao.deleteHistoryEntriesOlderThanNinetyDays();
        if (deletedEntries > 0L) {
            log.info("Deleted {} execution history entries", (Object)deletedEntries);
        }
        log.debug("Finished clean up of execution history entries");
        return deletedEntries;
    }
}

