/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.history;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.ExecutionHistoryCleanerJobRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExecutionHistoryCleaner {
    private static final Logger log = LoggerFactory.getLogger(ExecutionHistoryCleaner.class);
    private static final JobRunnerKey CLEANER_JOB_RUNNER_KEY = JobRunnerKey.of((String)"com.atlassian.servicedesk.plugins.automation.internal.execution.history.ExecutionHistoryCleaner");
    private static final JobId CLEANER_JOB_ID = JobId.of((String)"com.atlassian.servicedesk.plugins.automation.internal.execution.history.ExecutionHistoryCleaner.job");
    private final SchedulerService schedulerService;
    private final ExecutionHistoryCleanerJobRunner executionHistoryCleanerJobRunner;

    @Autowired
    public ExecutionHistoryCleaner(SchedulerService schedulerService, ExecutionHistoryCleanerJobRunner executionHistoryCleanerJobRunner) {
        this.schedulerService = schedulerService;
        this.executionHistoryCleanerJobRunner = executionHistoryCleanerJobRunner;
    }

    public void register() {
        log.info("Setting up automation execution history clean up schedule");
        log.info("Registering automation execution history clean up job runner");
        this.schedulerService.registerJobRunner(CLEANER_JOB_RUNNER_KEY, (JobRunner)this.executionHistoryCleanerJobRunner);
    }

    public void unregister() {
        log.info("Unregistering automation execution history clean up job runner");
        this.schedulerService.unregisterJobRunner(CLEANER_JOB_RUNNER_KEY);
        log.info("Unregistered automation execution history clean up job runner");
        log.info("Teared down automation execution history clean up schedule");
    }

    public void schedule() {
        log.info("Registered automation execution history clean up job runner");
        JobConfig config = JobConfig.forJobRunnerKey((JobRunnerKey)CLEANER_JOB_RUNNER_KEY).withSchedule(Schedule.forCronExpression((String)"0 0 2 * * ?")).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
        try {
            this.schedulerService.scheduleJob(CLEANER_JOB_ID, config);
            log.info("Successfully scheduled jobId={}", (Object)CLEANER_JOB_ID);
        }
        catch (SchedulerServiceException e) {
            log.error("Exception while setting up automation execution history clean up schedule", (Throwable)e);
        }
        log.info("Set up automation execution history clean up schedule");
    }

    public void unschedule() {
        log.info("Tearing down automation execution history clean up schedule");
        this.schedulerService.unscheduleJob(CLEANER_JOB_ID);
        log.info("Successfully unscheduled jobId={}", (Object)CLEANER_JOB_ID);
    }
}

