/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.vertigo;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.pocketknife.amq.api.fastfive.FastFiveManaged;
import com.atlassian.pocketknife.amq.api.offthread.OffThreadAccessor;
import com.atlassian.pocketknife.amq.api.offthread.OffThreadMethodRunner;
import com.atlassian.psmq.api.QSession;
import com.atlassian.psmq.api.QSessionDefinition;
import com.atlassian.psmq.api.QSessionDefinitionBuilder;
import com.atlassian.psmq.api.QSessionFactory;
import com.atlassian.psmq.api.message.QClaimant;
import com.atlassian.psmq.api.message.QMessageConsumer;
import com.atlassian.psmq.api.queue.Queue;
import com.atlassian.psmq.api.queue.QueueDefinition;
import com.atlassian.psmq.api.queue.QueueDefinitionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process.ExecutionJobProcessor;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.vertigo.ExecutionJobConverter;
import java.util.Optional;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class VertigoExecutionJobRunner
implements OffThreadMethodRunner {
    private static final Logger log = LoggerFactory.getLogger(VertigoExecutionJobRunner.class);
    private static final QClaimant QUEUE_READER_CLAIMANT = QClaimant.claimant((String)"com.atlassian.servicedesk.plugins.automation.execution.job.runner");
    private static final QSessionDefinition QUEUE_READER_SESSION = QSessionDefinitionBuilder.newDefinition().withAutoCommitStrategy().withClaimant(QUEUE_READER_CLAIMANT).build();
    private final OffThreadAccessor offThreadAccessor;
    private final QSessionFactory qSessionFactory;
    private final ExecutionJobConverter executionJobConverter;
    private final ExecutionJobProcessor executionJobProcessor;

    @Autowired
    public VertigoExecutionJobRunner(OffThreadAccessor offThreadAccessor, QSessionFactory qSessionFactory, ExecutionJobConverter executionJobConverter, ExecutionJobProcessor executionJobProcessor) {
        this.offThreadAccessor = offThreadAccessor;
        this.qSessionFactory = qSessionFactory;
        this.executionJobConverter = executionJobConverter;
        this.executionJobProcessor = executionJobProcessor;
    }

    @PostConstruct
    private void postConstruct() {
        this.offThreadAccessor.registerOffThreadMethodRunner((OffThreadMethodRunner)this);
    }

    public void runJobsInQueues(Set<String> queueNames) {
        for (String queueName : queueNames) {
            log.debug("Spawning a new job execution thread for queue '{}'", (Object)queueName);
            ((VertigoExecutionJobRunner)this.offThreadAccessor.runOffThread((OffThreadMethodRunner)this)).accessQueueAndProcessJobs(queueName);
        }
    }

    @FastFiveManaged
    protected void accessQueueAndProcessJobs(String queueName) {
        QueueDefinition queueDef = QueueDefinitionBuilder.newDefinition().withName(queueName).build();
        try (QSession session = this.qSessionFactory.createSession(QUEUE_READER_SESSION);){
            Optional queue = session.queueOperations().exclusiveAccessQueue(queueDef);
            if (queue.isPresent()) {
                this.processJobs(session, (Queue)queue.get());
            } else {
                log.debug("Ignoring request, another thread is currently processing jobs in queue '{}", (Object)queueName);
            }
        }
    }

    private void processJobs(QSession session, Queue queue) {
        log.debug("Processing jobs in queue '{}'", (Object)queue.name());
        QMessageConsumer consumer = session.createConsumer(queue);
        while (!session.queueOperations().releaseQueueIfEmpty(queue)) {
            consumer.claimAndResolve().map(this.executionJobConverter::fromQMessage).ifPresent(this.executionJobProcessor::processJob);
        }
        log.debug("Queue '{}' released", (Object)queue.name());
    }
}

