/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.sync;

import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.ExecutionJob;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.sync.ThreadLocalExecutionJobQueue;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Component;

@Component
public class ThreadLocalExecutionJobQueueImpl
implements ThreadLocalExecutionJobQueue {
    ThreadLocal<ExecutionQueueThreadLocal> threadLocalJobQueue = new ThreadLocal<ExecutionQueueThreadLocal>(){

        @Override
        protected ExecutionQueueThreadLocal initialValue() {
            return new ExecutionQueueThreadLocal();
        }
    };

    @Override
    public void enqueueJobsInThread(@Nonnull List<ExecutionJob> jobs) {
        if (jobs.isEmpty()) {
            return;
        }
        this.threadLocalJobQueue.get().addJobs(jobs);
    }

    @Override
    public Option<ExecutionJob> popSynchronousExecutionJob() {
        return this.threadLocalJobQueue.get().popSynchronousJob();
    }

    @Override
    public Queue<ExecutionJob> getAsynchronousExecutionJobQueueAndClear() {
        Queue<ExecutionJob> asynchronousJobs = this.threadLocalJobQueue.get().getAsynchronousJobs();
        this.threadLocalJobQueue.remove();
        return asynchronousJobs;
    }

    static class ExecutionQueueThreadLocal {
        private Queue<ExecutionJob> synchronousJobs = Lists.newLinkedList();
        private Queue<ExecutionJob> asynchronousJobs = Lists.newLinkedList();

        public void addJobs(List<ExecutionJob> jobs) {
            this.asynchronousJobs.addAll(jobs);
        }

        public Option<ExecutionJob> popSynchronousJob() {
            if (this.synchronousJobs.isEmpty()) {
                return Option.none();
            }
            return Option.option((Object)this.synchronousJobs.poll());
        }

        public Queue<ExecutionJob> getAsynchronousJobs() {
            return this.asynchronousJobs;
        }
    }
}

