/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process;

import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.If;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfThen;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.internal.analytics.AnalyticsService;
import com.atlassian.servicedesk.plugins.automation.internal.analytics.RuleExecutionEvent;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.IfThenImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.RuleImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.RuleExecutionException;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process.RuleActionInvoker;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process.RuleActionResult;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process.RuleMatcher;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process.RuleMatcherResult;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process.RuleProcessResult;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process.RuleProcessor;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewRuleExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.RulesEngineExecutionHistoryHelper;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewIfThenExecutionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewRuleExecutionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.RuleExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.spi.execution.RuleExecutionInterceptor;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class RuleProcessorImpl
implements RuleProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RuleProcessorImpl.class);
    private static final String ISSUE_ID_KEY = "issueId";
    private static final String PROJECT_ID_KEY = "projectId";
    private final RuleMatcher ruleMatcher;
    private final RuleActionInvoker ruleActionInvoker;
    private final RulesEngineExecutionHistoryHelper executionHistoryHelper;
    private final AnalyticsService analyticsService;
    private final IssueManager issueManager;

    @Autowired
    public RuleProcessorImpl(RuleMatcher ruleMatcher, RuleActionInvoker ruleActionInvoker, RulesEngineExecutionHistoryHelper executionHistoryHelper, AnalyticsService analyticsService, IssueManager issueManager) {
        this.ruleMatcher = ruleMatcher;
        this.ruleActionInvoker = ruleActionInvoker;
        this.executionHistoryHelper = executionHistoryHelper;
        this.analyticsService = analyticsService;
        this.issueManager = issueManager;
    }

    @Override
    public void doExecute(RuleExecutionInterceptor.RuleExecutionParam param) {
        this.process(param.getUser(), param.getRuleMessage(), param.getRule());
    }

    RuleProcessResult process(@Nonnull ApplicationUser user, @Nonnull RuleMessage message, @Nonnull Rule rule) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"message", (Object)message);
        Assertions.notNull((String)"rule", (Object)rule);
        RuleImpl impl = (RuleImpl)rule;
        LOG.debug("Executing rule with id '{}'", (Object)impl.getId());
        NewRuleExecutionBuilder auditEntryBuilder = this.executionHistoryHelper.builderForNewRuleExecution(user, rule, message);
        try {
            NewRuleExecution newRuleExecution = this.processImpl(rule, message, user, auditEntryBuilder);
            this.executionHistoryHelper.saveExecutionHistory(newRuleExecution);
            this.fireAnalyticsEvent(message);
            return new RuleProcessResult(newRuleExecution);
        }
        catch (RuleExecutionException e) {
            LOG.error("Unable to execute rule with id: " + impl.getId(), (Throwable)e);
            NewRuleExecution newRuleExecution = this.endRuleAuditEntryWithError(auditEntryBuilder);
            this.executionHistoryHelper.saveExecutionHistory(newRuleExecution);
            return new RuleProcessResult(newRuleExecution);
        }
    }

    @VisibleForTesting
    void fireAnalyticsEvent(@Nonnull RuleMessage message) {
        io.atlassian.fugue.Option issueIdOpt = StepsConverters.newerOption((Option)message.getValue(ISSUE_ID_KEY));
        issueIdOpt.forEach(issueId -> {
            io.atlassian.fugue.Option projectIdOpt = StepsConverters.newerOption((Option)message.getValue(PROJECT_ID_KEY));
            String projectId = (String)projectIdOpt.getOr(() -> String.valueOf(this.issueManager.getIssueObject(issueId).getProjectId()));
            this.analyticsService.fireAnalyticsEvent(new RuleExecutionEvent((String)issueId, projectId));
        });
    }

    private NewRuleExecution processImpl(Rule rule, RuleMessage message, ApplicationUser user, NewRuleExecutionBuilder auditEntryBuilder) {
        RuleImpl impl = (RuleImpl)rule;
        LOG.debug("Commencing evaluation of {} ifthens for rule with id '{}'", (Object)rule.getIfThens().size(), (Object)impl.getId());
        ArrayList newIfThenExecutionList = Lists.newArrayList();
        for (IfThen ifThen : rule.getIfThens()) {
            NewIfThenExecution newIfThenExecution = this.processIfThen(user, ifThen, message, impl);
            newIfThenExecutionList.add(newIfThenExecution);
            IfThenExecution.Outcome ifThenExecutionOutcome = (IfThenExecution.Outcome)((Object)newIfThenExecution.getResult().getOutcome());
            if (ifThenExecutionOutcome == IfThenExecution.Outcome.IF_DID_NOT_PASS) continue;
            break;
        }
        return this.completeAndBuildAuditEntry(auditEntryBuilder, newIfThenExecutionList);
    }

    private NewIfThenExecution processIfThen(ApplicationUser user, IfThen ifThen, RuleMessage message, RuleImpl rule) {
        NewIfThenExecutionBuilder ifThenAuditEntryBuilder = this.startIfThenAuditEntry(user, ifThen);
        If ruleIf = ifThen.getIf();
        LOG.debug("Evaluating if conditions for rule with id '{}'", (Object)ruleIf.getIfConditionConfigurations().size());
        RuleMatcherResult ruleMatchResult = this.ruleMatcher.match(message, ruleIf, user);
        boolean conditionsMet = ruleMatchResult.isMatched();
        if (conditionsMet) {
            LOG.debug("A set of rule matcher conditions held true for rule with id '{}'", (Object)rule.getId());
            LOG.debug("Invoking {} action(s) for rule with id '{}'", (Object)ifThen.getThen().getThenActionConfigurations().size(), (Object)rule.getId());
            RuleActionResult ruleActionResult = this.ruleActionInvoker.invokeActions(message, ifThen.getThen(), user);
            LOG.debug("Completed invoking {} action(s) for rule with id '{}'", (Object)ifThen.getThen().getThenActionConfigurations().size(), (Object)rule.getId());
            return this.endIfThenAuditEntryWithActionInvoked(ifThenAuditEntryBuilder, ruleMatchResult.getIfExecution(), ruleActionResult.getThenExecution());
        }
        return this.endIfThenAuditEntryWithNoActionInvoked(ifThenAuditEntryBuilder, ruleMatchResult.getIfExecution());
    }

    private NewRuleExecution completeAndBuildAuditEntry(NewRuleExecutionBuilder auditEntryBuilder, List<NewIfThenExecution> newIfThenExecutions) {
        boolean conditionsMet = false;
        RuleExecution.Outcome outcome = RuleExecution.Outcome.EXECUTED;
        for (NewIfThenExecution newIfThenExecution : newIfThenExecutions) {
            IfThenExecution.Outcome ifThenExecutionOutcome = (IfThenExecution.Outcome)((Object)newIfThenExecution.getResult().getOutcome());
            if (ifThenExecutionOutcome == IfThenExecution.Outcome.ERROR) {
                outcome = RuleExecution.Outcome.ERROR;
                break;
            }
            if (ifThenExecutionOutcome == IfThenExecution.Outcome.SOME_ACTIONS_INVOKED) {
                conditionsMet = true;
                outcome = RuleExecution.Outcome.ERROR;
                break;
            }
            if (ifThenExecutionOutcome != IfThenExecution.Outcome.ALL_ACTIONS_INVOKED) continue;
            conditionsMet = true;
            break;
        }
        if (!conditionsMet) {
            LOG.debug("No set of rule matcher conditions held true or no actions were defined for the rule with id '{}'");
            if (outcome != RuleExecution.Outcome.ERROR) {
                outcome = RuleExecution.Outcome.NOT_EXECUTED;
            }
        }
        for (NewIfThenExecution newIfThenExecution : newIfThenExecutions) {
            auditEntryBuilder.addIfThenExecution(newIfThenExecution);
        }
        NewRuleExecutionBuilder newRuleExecutionBuilder = auditEntryBuilder.finishTime(DateTime.now()).executionResult().outcome(outcome).endExecutionResult();
        return newRuleExecutionBuilder.build();
    }

    private NewRuleExecution endRuleAuditEntryWithError(NewRuleExecutionBuilder auditEntryBuilder) {
        NewRuleExecutionBuilder newRuleExecutionBuilder = auditEntryBuilder.finishTime(DateTime.now()).executionResult().outcome(RuleExecution.Outcome.ERROR).endExecutionResult();
        return newRuleExecutionBuilder.build();
    }

    private NewIfThenExecutionBuilder startIfThenAuditEntry(ApplicationUser user, IfThen ifThen) {
        long ifThenId = ((IfThenImpl)ifThen).getId();
        return NewIfThenExecutionBuilder.newBuilder().ifThenId(ifThenId).startTime(DateTime.now()).executedBy((io.atlassian.fugue.Option<String>)io.atlassian.fugue.Option.some((Object)user.getKey()));
    }

    private NewIfThenExecution endIfThenAuditEntryWithNoActionInvoked(NewIfThenExecutionBuilder newIfThenExecutionBuilder, NewIfExecution newIfExecution) {
        IfExecution.Outcome ifExecutionOutcome = (IfExecution.Outcome)((Object)newIfExecution.getResult().getOutcome());
        IfThenExecution.Outcome outcome = ifExecutionOutcome.equals((Object)IfExecution.Outcome.ERROR) ? IfThenExecution.Outcome.ERROR : (ifExecutionOutcome.equals((Object)IfExecution.Outcome.NOT_ALL_CONDITIONS_MET) ? IfThenExecution.Outcome.IF_DID_NOT_PASS : IfThenExecution.Outcome.ERROR);
        newIfThenExecutionBuilder.addIfExecution(newIfExecution);
        NewIfThenExecutionBuilder ifThenExecutionBuilder = newIfThenExecutionBuilder.finishTime(DateTime.now()).executionResult().outcome(outcome).endExecutionResult();
        return ifThenExecutionBuilder.build();
    }

    private NewIfThenExecution endIfThenAuditEntryWithActionInvoked(NewIfThenExecutionBuilder newIfThenExecutionBuilder, NewIfExecution newIfExecution, NewThenExecution newThenExecution) {
        IfExecution.Outcome ifExecutionOutcome = (IfExecution.Outcome)((Object)newIfExecution.getResult().getOutcome());
        ThenExecution.Outcome thenActionOutcome = (ThenExecution.Outcome)((Object)newThenExecution.getResult().getOutcome());
        IfThenExecution.Outcome outcome = ifExecutionOutcome == IfExecution.Outcome.ERROR || thenActionOutcome == ThenExecution.Outcome.ERROR ? IfThenExecution.Outcome.ERROR : (ifExecutionOutcome == IfExecution.Outcome.NOT_ALL_CONDITIONS_MET ? IfThenExecution.Outcome.IF_DID_NOT_PASS : (thenActionOutcome == ThenExecution.Outcome.SOME_ACTIONS_INVOKED ? IfThenExecution.Outcome.SOME_ACTIONS_INVOKED : IfThenExecution.Outcome.ALL_ACTIONS_INVOKED));
        newIfThenExecutionBuilder.addIfExecution(newIfExecution);
        newIfThenExecutionBuilder.addThenExecution(newThenExecution);
        NewIfThenExecutionBuilder ifThenExecutionBuilder = newIfThenExecutionBuilder.finishTime(DateTime.now()).executionResult().outcome(outcome).endExecutionResult();
        return ifThenExecutionBuilder.build();
    }
}

