/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.modules;

import com.atlassian.fugue.Either;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.UserMessageHelper;
import com.atlassian.servicedesk.plugins.automation.internal.spi.execution.RuleExecutionPreprocessor;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class SetCurrentUserPreprocessor
implements RuleExecutionPreprocessor {
    private final UserMessageHelper userMessageHelper;
    private final RuleMessageBuilderService ruleMessageBuilderService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public SetCurrentUserPreprocessor(UserMessageHelper userMessageHelper, RuleMessageBuilderService ruleMessageBuilderService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.userMessageHelper = userMessageHelper;
        this.ruleMessageBuilderService = ruleMessageBuilderService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public Either<AnError, RuleMessage> preprocess(@Nonnull RuleExecutionPreprocessor.PreprocessorParams params) {
        RuleMessage ruleMessage = params.getRuleMessage();
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (user == null) {
            return Either.right((Object)ruleMessage);
        }
        if (this.userMessageHelper.isDefined(ruleMessage, "currentUser")) {
            return Either.right((Object)ruleMessage);
        }
        RuleMessageBuilder builder = this.ruleMessageBuilderService.builder(ruleMessage);
        this.userMessageHelper.setUser(builder, "currentUser", user);
        return Either.right((Object)builder.build());
    }
}

