/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommand;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.featureflag.AutomationFeatureFlags;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.ExecutionJob;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.ExecutionJobManager;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.LegacyExecutionJobManager;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.VertigoExecutionJobManager;
import io.atlassian.fugue.Either;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelegatorExecutionJobManager
implements ExecutionJobManager {
    private static final Logger log = LoggerFactory.getLogger(DelegatorExecutionJobManager.class);
    private final LegacyExecutionJobManager legacyExecutionJobManager;
    private final VertigoExecutionJobManager vertigoExecutionJobManager;
    private final FeatureManager featureManager;

    @Autowired
    public DelegatorExecutionJobManager(LegacyExecutionJobManager legacyExecutionJobManager, VertigoExecutionJobManager vertigoExecutionJobManager, FeatureManager featureManager) {
        this.legacyExecutionJobManager = legacyExecutionJobManager;
        this.vertigoExecutionJobManager = vertigoExecutionJobManager;
        this.featureManager = featureManager;
    }

    private ExecutionJobManager getExecutionJobManager() {
        boolean vertigoJobManager = this.featureManager.isEnabled(AutomationFeatureFlags.VERTIGO_EXECUTION_ENGINE);
        if (vertigoJobManager) {
            log.debug("Automation engine is using the vertigo job runner");
            return this.vertigoExecutionJobManager;
        }
        log.debug("Automation engine is using the legacy job runner");
        return this.legacyExecutionJobManager;
    }

    @Override
    public Either<AnError, ExecutionJob> createJob(RuleExecutionCommand command) {
        return this.getExecutionJobManager().createJob(command);
    }

    @Override
    public void registerJobs(@Nonnull List<ExecutionJob> jobs) {
        this.getExecutionJobManager().registerJobs(jobs);
    }

    @Override
    public void executeJobs() {
        this.getExecutionJobManager().executeJobs();
    }
}

