/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.error;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorCode;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionErrorHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ThenActionErrorHelperImpl
implements ThenActionErrorHelper {
    @Nonnull
    public <T> Either<ThenActionError, T> error(@Nonnull ErrorMessage message, int httpStatusCode, @Nonnull Option<ErrorCode> errorCode) {
        return Either.left((Object)new ThenActionError(message, httpStatusCode, errorCode));
    }

    @Nonnull
    public <T> Either<ThenActionError, T> error(@Nonnull ErrorMessage message, int httpStatusCode) {
        return this.error(message, httpStatusCode, (Option<ErrorCode>)Option.none());
    }

    @Nonnull
    public <T> Either<ThenActionError, T> error(@Nonnull ErrorMessage message) {
        return this.error(message, HttpStatusCode.INTERNAL_SERVER_ERROR);
    }

    @Nonnull
    public <T> Either<ThenActionError, T> error(@Nonnull String message) {
        ErrorMessage errorMessage = ErrorMessage.builder().message(message).build();
        return this.error(errorMessage);
    }

    @Nonnull
    public <T> Either<ThenActionError, T> error(@Nonnull AnError anError) {
        return this.error(anError.getMessage(), anError.getHttpStatusCode(), (Option<ErrorCode>)anError.getErrorCode());
    }

    @Nonnull
    public <T> Either<ThenActionError, T> error(@Nonnull String errorMessage, @Nonnull ErrorCollection errorCollection) {
        StringBuilder errorBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((String)errorMessage)) {
            errorBuilder.append(errorMessage).append("\n");
        }
        for (String string : errorCollection.getErrorMessages()) {
            errorBuilder.append(string).append('\n');
        }
        for (Map.Entry entry : errorCollection.getErrors().entrySet()) {
            errorBuilder.append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append('\n');
        }
        return this.error(errorBuilder.toString());
    }
}

