/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.legacy;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.AsyncThenCommand;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.AsyncThenJobProcessor;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.legacy.LegacyAsyncThenJobQueue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class LegacyAsyncThenJobRunner
implements JobRunner {
    private final LegacyAsyncThenJobQueue jobQueue;
    private final SchedulerService schedulerService;
    private final AsyncThenJobProcessor asyncThenJobProcessor;
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)LegacyAsyncThenJobRunner.class.getName());

    @Autowired
    public LegacyAsyncThenJobRunner(LegacyAsyncThenJobQueue jobQueue, SchedulerService schedulerService, AsyncThenJobProcessor asyncThenJobProcessor) {
        this.jobQueue = jobQueue;
        this.schedulerService = schedulerService;
        this.asyncThenJobProcessor = asyncThenJobProcessor;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        AsyncThenCommand thenCommand;
        while ((thenCommand = this.jobQueue.poll()) != null) {
            this.asyncThenJobProcessor.run(thenCommand);
        }
        return JobRunnerResponse.success();
    }

    public void register() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
    }

    public void unregister() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }
}

