/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.legacy;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.AsyncThenCommand;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.AsyncThenExecutor;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.legacy.LegacyAsyncThenJobQueue;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.legacy.LegacyAsyncThenJobRunner;
import com.atlassian.util.concurrent.Assertions;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class LegacyAsyncThenExecutor
implements AsyncThenExecutor {
    private static final Logger log = LoggerFactory.getLogger(LegacyAsyncThenExecutor.class);
    private static final JobId EXECUTOR_JOB_ID = JobId.of((String)LegacyAsyncThenExecutor.class.getName());
    private final SchedulerService schedulerService;
    private final LegacyAsyncThenJobQueue jobQueue;
    private final ThenActionErrorHelper errorHelper;

    @Autowired
    public LegacyAsyncThenExecutor(SchedulerService schedulerService, LegacyAsyncThenJobQueue jobQueue, ThenActionErrorHelper errorHelper) {
        this.schedulerService = schedulerService;
        this.jobQueue = jobQueue;
        this.errorHelper = errorHelper;
    }

    @Override
    public io.atlassian.fugue.Either<ThenActionError, RuleMessage> run(AsyncThenCommand asyncThenCommand) {
        Assertions.notNull((String)"asyncThenCommand", (Object)asyncThenCommand);
        try {
            this.jobQueue.enqueue(asyncThenCommand);
            this.schedulerService.scheduleJob(EXECUTOR_JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)LegacyAsyncThenJobRunner.JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY));
        }
        catch (SchedulerServiceException e) {
            log.error("Failed scheduling ThenAction for asynchronous execution", (Throwable)e);
            this.jobQueue.remove(asyncThenCommand);
            return StepsConverters.newerEither((Either)this.errorHelper.error("Failed scheduling ThenAction for asynchronous execution"));
        }
        return io.atlassian.fugue.Either.right((Object)asyncThenCommand.getThenActionParam().getMessage());
    }
}

