/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.featureflag.AutomationFeatureFlags;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.AsyncThenCommand;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.AsyncThenExecutor;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.legacy.LegacyAsyncThenExecutor;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.vertigo.VertigoAsyncThenExecutor;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenAction;
import io.atlassian.fugue.Either;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class AsyncThenExecutorDelegator
implements AsyncThenExecutor {
    private static final Logger log = LoggerFactory.getLogger(AsyncThenExecutorDelegator.class);
    private final FeatureManager featureManager;
    private final VertigoAsyncThenExecutor vertigoAsyncThenExecutor;
    private final LegacyAsyncThenExecutor legacyAsyncThenExecutor;

    @Autowired
    public AsyncThenExecutorDelegator(FeatureManager featureManager, VertigoAsyncThenExecutor vertigoAsyncThenExecutor, LegacyAsyncThenExecutor legacyAsyncThenExecutor) {
        this.featureManager = featureManager;
        this.vertigoAsyncThenExecutor = vertigoAsyncThenExecutor;
        this.legacyAsyncThenExecutor = legacyAsyncThenExecutor;
    }

    @Override
    public Either<ThenActionError, RuleMessage> run(AsyncThenCommand asyncThenCommand) {
        return this.getAsyncThenExecutor(asyncThenCommand.getThenActionParam()).run(asyncThenCommand);
    }

    private AsyncThenExecutor getAsyncThenExecutor(ThenAction.ThenActionParam infoForLogging) {
        if (this.vertigoExecutionEngineEnabled()) {
            this.logExecution("vertigo", infoForLogging.getConfiguration().getModuleKey());
            return this.vertigoAsyncThenExecutor;
        }
        this.logExecution("legacy", infoForLogging.getConfiguration().getModuleKey());
        return this.legacyAsyncThenExecutor;
    }

    private void logExecution(String type, String moduleKey) {
        log.debug("Async then with module key '{}' is being executed using the {} async then executor", (Object)moduleKey, (Object)type);
    }

    private boolean vertigoExecutionEngineEnabled() {
        return this.featureManager.isEnabled(AutomationFeatureFlags.VERTIGO_EXECUTION_ENGINE);
    }
}

