/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.async;

import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.async.AsynchronousExecutionJobQueue;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.ExecutionJob;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process.ExecutionJobProcessor;
import io.atlassian.fugue.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AsynchronousExecutionJobExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(AsynchronousExecutionJobExecutor.class);
    private final ExecutionJobProcessor executionJobProcessor;
    private final AsynchronousExecutionJobQueue asynchronousExecutionJobQueue;

    @Autowired
    public AsynchronousExecutionJobExecutor(ExecutionJobProcessor executionJobProcessor, AsynchronousExecutionJobQueue asynchronousExecutionJobQueue) {
        this.executionJobProcessor = executionJobProcessor;
        this.asynchronousExecutionJobQueue = asynchronousExecutionJobQueue;
    }

    public void execute() {
        Option<ExecutionJob> job;
        do {
            if (!(job = this.asynchronousExecutionJobQueue.popAsynchronousExecutionJob()).isDefined()) continue;
            this.executionJobProcessor.processJob((ExecutionJob)job.get());
        } while (job.isDefined());
    }
}

