/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.descriptors;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.servicedesk.plugins.automation.spi.rulewhen.event.EventWhenHandler;
import com.atlassian.util.concurrent.LazyReference;
import javax.annotation.Nonnull;
import org.dom4j.Element;

public class EventWhenHandlerModuleDescriptor
extends AbstractModuleDescriptor<EventWhenHandler> {
    private static final String COMPLETE_MODULE_KEY_SEPARATOR = ":";
    private String whenHandlerCompleteKey = null;
    @TenantAware(value=TenancyScope.TENANTLESS)
    private final LazyReference<EventWhenHandler> moduleReference = new LazyReference<EventWhenHandler>(){

        protected EventWhenHandler create() throws Exception {
            return EventWhenHandlerModuleDescriptor.this.createModule();
        }
    };

    public EventWhenHandlerModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        Element whenHandler = element.element("automation-rule-when-handler");
        if (whenHandler != null) {
            String completeKey = whenHandler.attributeValue("complete-key");
            String moduleKey = whenHandler.attributeValue("module-key");
            if (completeKey != null) {
                this.whenHandlerCompleteKey = completeKey;
            } else if (moduleKey != null) {
                this.whenHandlerCompleteKey = plugin.getKey() + COMPLETE_MODULE_KEY_SEPARATOR + moduleKey;
            }
        }
        if (this.whenHandlerCompleteKey == null) {
            throw new IllegalArgumentException("When handler module key not defined");
        }
    }

    public EventWhenHandler getModule() {
        return (EventWhenHandler)this.moduleReference.get();
    }

    public String getWhenHandlerCompleteKey() {
        return this.whenHandlerCompleteKey;
    }

    protected EventWhenHandler createModule() {
        return (EventWhenHandler)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }
}

