/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.descriptors;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.fugue.Option;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.ozymandias.SafeBeanInstantiator;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.AbstractConditionalAutomationModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.condition.ConditionDescriptorFactory;
import com.atlassian.servicedesk.plugins.automation.spi.configuration.ConfigurationProcessor;
import com.atlassian.servicedesk.plugins.automation.spi.ruleif.IfConditionValidator;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenActionValidator;
import com.atlassian.servicedesk.plugins.automation.spi.rulewhen.WhenHandlerValidator;
import com.atlassian.servicedesk.plugins.automation.spi.visualiser.RuleComponentVisualiser;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import org.dom4j.Element;

public abstract class AbstractRuleComponentModuleDescriptor<T, U>
extends AbstractConditionalAutomationModuleDescriptor<T> {
    private Option<String> iconClass;
    private Option<String> webFormModule;
    private Option<String> visualiserClassName;
    private Option<String> validatorClassName;
    private Option<String> configurationProcessorClassName;
    @TenantAware(value=TenancyScope.TENANTLESS)
    private final LazyReference<Option<RuleComponentVisualiser>> visualiserReference = new LazyReference<Option<RuleComponentVisualiser>>(){

        protected Option<RuleComponentVisualiser> create() throws Exception {
            return AbstractRuleComponentModuleDescriptor.this.createVisualiser();
        }
    };
    @TenantAware(value=TenancyScope.TENANTLESS)
    private final LazyReference<Option<U>> validatorReference = new LazyReference<Option<U>>(){

        protected Option<U> create() throws Exception {
            return AbstractRuleComponentModuleDescriptor.this.createValidator();
        }
    };
    @TenantAware(value=TenancyScope.TENANTLESS)
    private final LazyReference<Option<ConfigurationProcessor>> configurationProcessorReference = new LazyReference<Option<ConfigurationProcessor>>(){

        protected Option<ConfigurationProcessor> create() throws Exception {
            return AbstractRuleComponentModuleDescriptor.this.createConfigurationProcessor();
        }
    };

    protected AbstractRuleComponentModuleDescriptor(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory, ConditionDescriptorFactory conditionDescriptorFactory) {
        super(authenticationContext, moduleFactory, conditionDescriptorFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.iconClass = Option.none();
        Option iconOption = Option.option((Object)element.element("icon-class"));
        if (iconOption.isDefined()) {
            this.iconClass = Option.option((Object)((Element)iconOption.get()).getText());
        }
        this.visualiserClassName = Option.none();
        Option visualiser = Option.option((Object)element.element("visualiser"));
        if (visualiser.isDefined()) {
            this.visualiserClassName = Option.option((Object)((Element)visualiser.get()).attributeValue("class"));
        }
        this.validatorClassName = Option.none();
        Option validator = Option.option((Object)element.element("validator"));
        if (validator.isDefined()) {
            this.validatorClassName = Option.option((Object)((Element)validator.get()).attributeValue("class"));
        }
        this.configurationProcessorClassName = Option.none();
        Option configurationProcessor = Option.option((Object)element.element("configuration-processor"));
        if (configurationProcessor.isDefined()) {
            this.configurationProcessorClassName = Option.option((Object)((Element)configurationProcessor.get()).attributeValue("class"));
        }
        this.webFormModule = Option.none();
        Option webFormModuleOption = Option.option((Object)element.element("web-form-module"));
        if (webFormModuleOption.isDefined()) {
            this.webFormModule = Option.option((Object)((Element)webFormModuleOption.get()).getText());
        }
    }

    @Nonnull
    public Option<String> getIconClass() {
        return this.iconClass;
    }

    @Nonnull
    public Option<String> getWebFormModule() {
        return this.webFormModule;
    }

    @Nonnull
    public Option<RuleComponentVisualiser> getVisualiser() {
        return (Option)this.visualiserReference.get();
    }

    @Nonnull
    public Option<U> getValidator() {
        return (Option)this.validatorReference.get();
    }

    @Nonnull
    public Option<ConfigurationProcessor> getConfigurationProcessor() {
        return (Option)this.configurationProcessorReference.get();
    }

    public abstract Class<U> getValidatorClass();

    @Nonnull
    private Option<RuleComponentVisualiser> createVisualiser() {
        if (this.visualiserClassName.isEmpty()) {
            return Option.none();
        }
        return SafeBeanInstantiator.load((String)((String)this.visualiserClassName.get()), RuleComponentVisualiser.class, ((Object)((Object)this)).getClass(), (Plugin)this.plugin);
    }

    private Option<U> createValidator() {
        if (this.validatorClassName.isEmpty()) {
            return Option.none();
        }
        Option validatorBean = SafeBeanInstantiator.load((String)((String)this.validatorClassName.get()), this.getValidatorClass(), ((Object)((Object)this)).getClass(), (Plugin)this.plugin);
        if (validatorBean.isEmpty()) {
            return Option.some((Object)new ErrorFallbackRuleComponentValidator("sd.automation.validator.bean.instantiation.failure", (String)this.validatorClassName.get()));
        }
        return validatorBean;
    }

    @Nonnull
    private Option<ConfigurationProcessor> createConfigurationProcessor() {
        if (this.configurationProcessorClassName.isEmpty()) {
            return Option.none();
        }
        return SafeBeanInstantiator.load((String)((String)this.configurationProcessorClassName.get()), ConfigurationProcessor.class, ((Object)((Object)this)).getClass(), (Plugin)this.plugin);
    }

    private class ErrorFallbackRuleComponentValidator
    implements IfConditionValidator,
    WhenHandlerValidator,
    ThenActionValidator {
        private final String errorMessageI18nKey;
        private final String validatorClassName;

        ErrorFallbackRuleComponentValidator(String errorMessageI18nKey, String validatorClassName) {
            this.errorMessageI18nKey = errorMessageI18nKey;
            this.validatorClassName = validatorClassName;
        }

        private ValidationResult invalidResult() {
            return ValidationResult.FAILED((List)Lists.newArrayList((Object[])new String[]{AbstractRuleComponentModuleDescriptor.this.getAuthenticationContext().getI18nHelper().getText(this.errorMessageI18nKey, this.validatorClassName)}));
        }

        public ValidationResult validate(@Nonnull IfConditionValidator.IfConditionValidationParam ifConditionValidationParam) {
            return this.invalidResult();
        }

        public ValidationResult validate(@Nonnull ThenActionValidator.ThenActionValidationParam thenActionValidationParam) {
            return this.invalidResult();
        }

        public ValidationResult validate(@Nonnull WhenHandlerValidator.WhenHandlerValidationParam whenHandlerValidationParam) {
            return this.invalidResult();
        }
    }
}

