/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.user;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.user.RunAsCurrentUserContextConfigImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.user.RunAsSpecificUserContextConfigImpl;
import com.atlassian.util.concurrent.Assertions;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class RunAsUserContextConfigDataExtractor {
    @TenantAware(value=TenancyScope.TENANTLESS)
    private static Map<Class<? extends RunAsUserContextConfig>, String> typeToStrategyNameMap = new HashMap<Class<? extends RunAsUserContextConfig>, String>();

    public static RunAsUserContextConfigData extract(RunAsUserContextConfig toExtractFrom) {
        Assertions.notNull((String)"toExtractFrom is required", (Object)toExtractFrom);
        if (toExtractFrom instanceof RunAsCurrentUserContextConfigImpl) {
            return new RunAsUserContextConfigData(RunAsUserContextConfigDataExtractor.strategyNameFor(RunAsCurrentUserContextConfigImpl.class), (Option<String>)Option.none());
        }
        if (toExtractFrom instanceof RunAsSpecificUserContextConfigImpl) {
            RunAsSpecificUserContextConfigImpl specificUserContextConfig = (RunAsSpecificUserContextConfigImpl)toExtractFrom;
            return new RunAsUserContextConfigData(RunAsUserContextConfigDataExtractor.strategyNameFor(RunAsSpecificUserContextConfigImpl.class), (Option<String>)Option.option((Object)specificUserContextConfig.getUserKey()));
        }
        throw new IllegalArgumentException("Cannot extract data from a RunAsUserContextConfig instance. The type " + toExtractFrom.getClass() + " is not supported.");
    }

    private static String strategyNameFor(Class<? extends RunAsUserContextConfig> runAsUserContextConfigSubclass) {
        return typeToStrategyNameMap.get(runAsUserContextConfigSubclass);
    }

    static {
        typeToStrategyNameMap.put(RunAsCurrentUserContextConfigImpl.class, "currentUser");
        typeToStrategyNameMap.put(RunAsSpecificUserContextConfigImpl.class, "specificUser");
    }

    public static class RunAsUserContextConfigData {
        public final String strategyName;
        public final Option<String> userKey;

        public RunAsUserContextConfigData(String strategyName, Option<String> userKey) {
            Assertions.isTrue((String)"strategyName is required", (boolean)StringUtils.isNotBlank((CharSequence)strategyName));
            Assertions.notNull((String)"userId is required", userKey);
            this.strategyName = strategyName;
            this.userKey = userKey;
        }
    }
}

