/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.store;

import com.atlassian.fugue.Either;
import com.atlassian.ozymandias.PluginPointFunction;
import com.atlassian.ozymandias.SafeAccessViaPluginAccessor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfConditionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ThenActionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.WhenHandlerConfiguration;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ConfigurationDataImpl;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.condition.ConditionAwarePluginPointFunction;
import com.atlassian.servicedesk.plugins.automation.internal.spi.descriptors.IfConditionModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.internal.spi.descriptors.ThenActionModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.internal.spi.descriptors.WhenHandlerModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.spi.configuration.ConfigurationProcessor;
import com.atlassian.servicedesk.plugins.automation.spi.ruleif.IfCondition;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenAction;
import io.atlassian.fugue.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationProcessorManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationProcessorManager.class);
    private final PluginAccessor pluginAccessor;

    @Autowired
    public ConfigurationProcessorManager(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public ConfigurationData postLoad(ConfigurationData data, String moduleKey) {
        return (ConfigurationData)this.retrieveConfigurationProcessor(moduleKey).map(processor -> new ConfigurationDataImpl(processor.postLoad(data.getAll()))).getOrElse((Object)data);
    }

    public ConfigurationData preStore(WhenHandlerConfiguration whenHandlerConfig) {
        return this.preStoreInternal(whenHandlerConfig.getData(), whenHandlerConfig.getModuleKey());
    }

    public ConfigurationData preStore(IfConditionConfiguration ifConditionConfig) {
        return this.preStoreInternal(ifConditionConfig.getData(), ifConditionConfig.getModuleKey());
    }

    public ConfigurationData preStore(ThenActionConfiguration thenActionConfig) {
        return this.preStoreInternal(thenActionConfig.getData(), thenActionConfig.getModuleKey());
    }

    private ConfigurationData preStoreInternal(ConfigurationData configData, String moduleKey) {
        return (ConfigurationData)this.retrieveConfigurationProcessor(moduleKey).map(processor -> new ConfigurationDataImpl(processor.preStore(configData.getAll()))).getOrElse((Object)configData);
    }

    private Option<ConfigurationProcessor> retrieveConfigurationProcessor(String moduleKey) {
        try {
            SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
            io.atlassian.fugue.Either<? extends ModuleAccessError, Option<ConfigurationProcessor>> optionEither = this.retrieveProcessorFromThenConfiguration(moduleKey, safeAccessor);
            if (optionEither.isLeft()) {
                optionEither = this.retrieveProcessorFromWhenConfiguration(moduleKey, safeAccessor);
            }
            if (optionEither.isLeft()) {
                optionEither = this.retrieveProcessorFromIfConfiguration(moduleKey, safeAccessor);
            }
            return optionEither.toOption().flatMap(content -> content);
        }
        catch (Exception e) {
            LOG.warn("Exception while loading extended configuration store.", (Throwable)e);
            return Option.none();
        }
    }

    private io.atlassian.fugue.Either<? extends ModuleAccessError, Option<ConfigurationProcessor>> retrieveProcessorFromThenConfiguration(String moduleKey, SafeAccessViaPluginAccessor safeAccessor) {
        return StepsConverters.newerEither((Either)safeAccessor.forKey(moduleKey, ThenActionModuleDescriptor.class, (PluginPointFunction)new ConditionAwarePluginPointFunction<ThenActionModuleDescriptor, ThenAction, Option<ConfigurationProcessor>>(){

            @Override
            protected Option<ConfigurationProcessor> onModuleShouldDisplay(ThenActionModuleDescriptor moduleDescriptor, ThenAction thenAction) {
                return StepsConverters.newerOption(moduleDescriptor.getConfigurationProcessor());
            }

            @Override
            protected Option<ConfigurationProcessor> onModuleShouldNotDisplay(ThenActionModuleDescriptor moduleDescriptor, ThenAction module) {
                return Option.none();
            }
        }));
    }

    private io.atlassian.fugue.Either<? extends ModuleAccessError, Option<ConfigurationProcessor>> retrieveProcessorFromIfConfiguration(String moduleKey, SafeAccessViaPluginAccessor safeAccessor) {
        return StepsConverters.newerEither((Either)safeAccessor.forKey(moduleKey, IfConditionModuleDescriptor.class, (PluginPointFunction)new ConditionAwarePluginPointFunction<IfConditionModuleDescriptor, IfCondition, Option<ConfigurationProcessor>>(){

            @Override
            protected Option<ConfigurationProcessor> onModuleShouldDisplay(IfConditionModuleDescriptor moduleDescriptor, IfCondition ifCondition) {
                return StepsConverters.newerOption(moduleDescriptor.getConfigurationProcessor());
            }

            @Override
            protected Option<ConfigurationProcessor> onModuleShouldNotDisplay(IfConditionModuleDescriptor moduleDescriptor, IfCondition ifCondition) {
                return Option.none();
            }
        }));
    }

    private io.atlassian.fugue.Either<? extends ModuleAccessError, Option<ConfigurationProcessor>> retrieveProcessorFromWhenConfiguration(String moduleKey, SafeAccessViaPluginAccessor safeAccessor) {
        return StepsConverters.newerEither((Either)safeAccessor.forKey(moduleKey, WhenHandlerModuleDescriptor.class, (PluginPointFunction)new ConditionAwarePluginPointFunction<WhenHandlerModuleDescriptor, String, Option<ConfigurationProcessor>>(){

            @Override
            protected Option<ConfigurationProcessor> onModuleShouldDisplay(WhenHandlerModuleDescriptor moduleDescriptor, String module) {
                return StepsConverters.newerOption(moduleDescriptor.getConfigurationProcessor());
            }

            @Override
            protected Option<ConfigurationProcessor> onModuleShouldNotDisplay(WhenHandlerModuleDescriptor moduleDescriptor, String module) {
                return Option.none();
            }
        }));
    }
}

