/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Then;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ThenActionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ThenValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ComponentConfigurationImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ThenImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.ComponentConfigurationInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.ThenInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.module.ThenActionManager;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ThenValidator {
    private final ThenActionManager thenActionManager;
    private I18nHelper.BeanFactory i18nFactory;

    @Autowired
    public ThenValidator(ThenActionManager thenActionManager, I18nHelper.BeanFactory i18nFactory) {
        this.thenActionManager = thenActionManager;
        this.i18nFactory = i18nFactory;
    }

    public ThenValidationResult validateThenInput(@Nonnull ApplicationUser user, @Nonnull ThenInputImpl thenInput, @Nonnull Option<ProjectContext> projectContext, @Nonnull Set<String> provides) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"thenInput", (Object)thenInput);
        Assertions.notNull((String)"projectContext", projectContext);
        Assertions.notNull((String)"provides", provides);
        ValidationResult validationResult = this.validateSelf(user, thenInput.getThenActionConfigurationInputs());
        List thenActionValidationResults = thenInput.getThenActionConfigurationInputs().stream().map(thenActionConfiguration -> this.validationThenActionInput(user, (ComponentConfigurationInputImpl)thenActionConfiguration, projectContext, provides)).collect(Collectors.toList());
        return new ThenValidationResult(validationResult, thenActionValidationResults);
    }

    public ValidationResult validationThenActionInput(@Nonnull ApplicationUser user, @Nonnull ComponentConfigurationInputImpl componentConfigurationInput, @Nonnull Option<ProjectContext> projectContext, @Nonnull Set<String> provides) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"componentConfigurationInput", (Object)componentConfigurationInput);
        Assertions.notNull((String)"projectContext", projectContext);
        Assertions.notNull((String)"provides", provides);
        String moduleKey = (String)componentConfigurationInput.getModuleKey().getOrNull();
        if (StringUtils.isBlank((String)moduleKey)) {
            return ValidationResult.FAILED((List)Lists.newArrayList((Object[])new String[]{this.getI18n(user).getText("sd.automation.rule.set.error.component.module.key.missing")}));
        }
        ComponentConfigurationImpl thenActionConfiguration = new ComponentConfigurationImpl(-1L, moduleKey, componentConfigurationInput.getData());
        return this.validateThenAction(user, thenActionConfiguration, projectContext, provides);
    }

    public ThenValidationResult validateThen(@Nonnull ApplicationUser user, @Nonnull Then then, @Nonnull Option<ProjectContext> projectContext, @Nonnull Set<String> provides) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"then", (Object)then);
        Assertions.notNull((String)"projectContext", projectContext);
        Assertions.notNull((String)"provides", provides);
        ValidationResult validationResult = this.validateSelf(user, then.getThenActionConfigurations());
        List thenActionValidationResults = then.getThenActionConfigurations().stream().map(thenActionConfiguration -> this.validateThenAction(user, (ThenActionConfiguration)thenActionConfiguration, projectContext, provides)).collect(Collectors.toList());
        return new ThenValidationResult(validationResult, thenActionValidationResults);
    }

    public Then transformInput(@Nonnull ThenInputImpl then) {
        Assertions.notNull((String)"then is required", (Object)then);
        List<ThenActionConfiguration> thenActionConfigurations = then.getThenActionConfigurationInputs().stream().map(thenConfiguration -> {
            Assertions.notNull((String)"moduleKey is required", (Object)thenConfiguration.getModuleKey().getOrNull());
            return new ComponentConfigurationImpl(-1L, (String)thenConfiguration.getModuleKey().get(), thenConfiguration.getData());
        }).collect(Collectors.toList());
        return new ThenImpl(thenActionConfigurations);
    }

    private ValidationResult validateThenAction(ApplicationUser user, ThenActionConfiguration thenActionConfiguration, Option<ProjectContext> projectContext, Set<String> provides) {
        Either<? extends ModuleAccessError, ValidationResult> result = this.thenActionManager.validateThenAction(user, thenActionConfiguration, projectContext, provides);
        if (result.isLeft()) {
            return ValidationResult.FAILED((List)Lists.newArrayList((Object[])new String[]{this.getI18n(user).getText("sd.automation.rule.set.error.component.failed.to.execute.validator", thenActionConfiguration.getModuleKey(), ((ModuleAccessError)result.left().get()).getErrorMessage())}));
        }
        return (ValidationResult)result.right().get();
    }

    private ValidationResult validateSelf(@Nonnull ApplicationUser user, @Nonnull List<?> thenActionConfiguration) {
        ArrayList componentErrors = Lists.newArrayList();
        if (thenActionConfiguration.isEmpty()) {
            componentErrors.add(this.getI18n(user).getText("sd.automation.rule.set.error.rule.must.contain.an.then.action"));
        }
        return !componentErrors.isEmpty() ? ValidationResult.FAILED((List)componentErrors) : ValidationResult.PASSED();
    }

    private I18nHelper getI18n(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }
}

