/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfThen;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.When;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.IfThenValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.RuleValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.WhenValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.RuleImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.IfThenInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.RuleInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation.IfThenValidator;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation.WhenValidator;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerProvidesManager;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleValidator {
    private final IfThenValidator ifThenValidator;
    private final WhenValidator whenValidator;
    private final WhenHandlerProvidesManager whenHandlerProvidesManager;
    private I18nHelper.BeanFactory i18nFactory;

    @Autowired
    public RuleValidator(WhenValidator whenValidator, IfThenValidator ifThenValidator, WhenHandlerProvidesManager whenHandlerProvidesManager, I18nHelper.BeanFactory i18nFactory) {
        this.whenValidator = whenValidator;
        this.ifThenValidator = ifThenValidator;
        this.whenHandlerProvidesManager = whenHandlerProvidesManager;
        this.i18nFactory = i18nFactory;
    }

    public RuleValidationResult validateRuleInput(@Nonnull ApplicationUser user, @Nonnull RuleInputImpl ruleConfiguration, @Nonnull Option<ProjectContext> projectContext) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"ruleConfiguration", (Object)ruleConfiguration);
        Assertions.notNull((String)"projectContext", projectContext);
        Set provides = (Set)this.whenHandlerProvidesManager.retrieveProvides(user, ruleConfiguration).getOrElse(Collections.emptySet());
        ValidationResult validationResult = this.validateData(user, ruleConfiguration.getIfThenInputs());
        WhenValidationResult whenValidationResult = this.whenValidator.validateWhenInput(user, ruleConfiguration.getWhenInputs(), projectContext);
        List<IfThenValidationResult> ifThenValidationResults = this.validateIfThenInputs(user, ruleConfiguration.getIfThenInputs(), projectContext, provides);
        return new RuleValidationResult(validationResult, whenValidationResult, ifThenValidationResults);
    }

    public RuleValidationResult validateRule(@Nonnull ApplicationUser user, @Nonnull Rule ruleConfiguration, @Nonnull Option<ProjectContext> projectContext) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"ruleConfiguration", (Object)ruleConfiguration);
        Assertions.notNull((String)"projectContext", projectContext);
        Set provides = (Set)this.whenHandlerProvidesManager.retrieveProvides(user, ruleConfiguration).getOrElse(Collections.emptySet());
        ValidationResult validationResult = this.validateData(user, ruleConfiguration.getIfThens());
        WhenValidationResult whenValidationResult = this.whenValidator.validateWhen(user, ruleConfiguration.getWhen(), projectContext);
        List<IfThenValidationResult> ifThenValidationResults = this.validateIfThens(user, ruleConfiguration.getIfThens(), projectContext, provides);
        return new RuleValidationResult(validationResult, whenValidationResult, ifThenValidationResults);
    }

    public Rule transformInput(@Nonnull RuleInputImpl rule) {
        Assertions.notNull((String)"rule is required", (Object)rule);
        When when = this.whenValidator.transformInput(rule.getWhenInputs());
        List<IfThen> ifThens = rule.getIfThenInputs().stream().map(this.ifThenValidator::transformInput).collect(Collectors.toList());
        return new RuleImpl(-1L, when, ifThens, rule.isEnabled());
    }

    private ValidationResult validateData(ApplicationUser user, List<?> ifThens) {
        ArrayList componentErrors = Lists.newArrayList();
        if (ifThens.isEmpty()) {
            componentErrors.add(this.getI18n(user).getText("sd.automation.rule.set.error.rule.must.contain.an.if.then"));
        }
        return !componentErrors.isEmpty() ? ValidationResult.FAILED((List)componentErrors, Collections.emptyMap()) : ValidationResult.PASSED();
    }

    private List<IfThenValidationResult> validateIfThenInputs(ApplicationUser user, List<IfThenInputImpl> ifThens, Option<ProjectContext> projectContext, Set<String> provides) {
        return ifThens.stream().map(ifThen -> {
            Boolean islast = ifThens.indexOf(ifThen) == ifThens.size() - 1;
            return this.ifThenValidator.validateIfThenInput(user, (IfThenInputImpl)ifThen, islast, projectContext, provides);
        }).collect(Collectors.toList());
    }

    private List<IfThenValidationResult> validateIfThens(ApplicationUser user, List<IfThen> ifThens, Option<ProjectContext> projectContext, Set<String> provides) {
        return ifThens.stream().map(ifThen -> {
            Boolean islast = ifThens.indexOf(ifThen) == ifThens.size() - 1;
            return this.ifThenValidator.validateIfThen(user, (IfThen)ifThen, islast, projectContext, provides);
        }).collect(Collectors.toList());
    }

    private I18nHelper getI18n(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }
}

