/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputValidationService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.RuleSetValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidatedRuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationOutcome;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation.RuleSetValidator;
import com.atlassian.util.concurrent.Assertions;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public final class RuleSetInputValidationServiceImpl
implements RuleSetInputValidationService {
    private final RuleSetValidator ruleSetValidator;

    @Autowired
    public RuleSetInputValidationServiceImpl(RuleSetValidator ruleSetValidator) {
        this.ruleSetValidator = ruleSetValidator;
    }

    public Either<AnError, ValidationOutcome> validate(@Nonnull ApplicationUser userToValidateWith, @Nonnull RuleSetInput toValidate) {
        Assertions.notNull((String)"userToValidateWith is required", (Object)userToValidateWith);
        Assertions.notNull((String)"toValidate is required", (Object)toValidate);
        RuleSetValidationResult validationResult = this.ruleSetValidator.validateRuleSetInput(userToValidateWith, toValidate);
        if (!validationResult.isPassed()) {
            return StepsConverters.olderEither((io.atlassian.fugue.Either)io.atlassian.fugue.Either.right((Object)new ValidationOutcome(validationResult)));
        }
        ValidatedRuleSet validatedRuleSet = this.ruleSetValidator.transformInput(toValidate);
        return StepsConverters.olderEither((io.atlassian.fugue.Either)io.atlassian.fugue.Either.right((Object)new ValidationOutcome(validationResult, validatedRuleSet)));
    }
}

